/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRuleExtPayLoad;
import org.onosproject.net.flow.IndexTableId;
import org.onosproject.net.flow.TableId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.pi.service.PiTranslatable;

public interface FlowRule
extends PiTranslatable {
    public static final IndexTableId DEFAULT_TABLE = IndexTableId.of(0);
    public static final int MAX_TIMEOUT = 60;
    public static final int MIN_PRIORITY = 0;
    public static final int MAX_PRIORITY = 65535;

    public FlowId id();

    public short appId();

    public GroupId groupId();

    public int priority();

    public DeviceId deviceId();

    public TrafficSelector selector();

    public TrafficTreatment treatment();

    public int timeout();

    public int hardTimeout();

    public FlowRemoveReason reason();

    public boolean isPermanent();

    @Deprecated
    public int tableId();

    public TableId table();

    public boolean equals(Object var1);

    public boolean exactMatch(FlowRule var1);

    @Deprecated
    public FlowRuleExtPayLoad payLoad();

    public static interface Builder {
        public Builder withCookie(long var1);

        public Builder fromApp(ApplicationId var1);

        public Builder withPriority(int var1);

        public Builder forDevice(DeviceId var1);

        public Builder forTable(int var1);

        public Builder forTable(TableId var1);

        public Builder withSelector(TrafficSelector var1);

        public Builder withTreatment(TrafficTreatment var1);

        public Builder makePermanent();

        public Builder makeTemporary(int var1);

        default public Builder withIdleTimeout(int timeout) {
            if (timeout == 0) {
                return this.makePermanent();
            }
            return this.makeTemporary(timeout);
        }

        public Builder withHardTimeout(int var1);

        public Builder withReason(FlowRemoveReason var1);

        public FlowRule build();
    }

    public static enum FlowRemoveReason {
        IDLE_TIMEOUT,
        HARD_TIMEOUT,
        DELETE,
        GROUP_DELETE,
        METER_DELETE,
        EVICTION,
        NO_REASON;


        public static FlowRemoveReason parseShort(short reason) {
            switch (reason) {
                case -1: {
                    return NO_REASON;
                }
                case 0: {
                    return IDLE_TIMEOUT;
                }
                case 1: {
                    return HARD_TIMEOUT;
                }
                case 2: {
                    return DELETE;
                }
                case 3: {
                    return GROUP_DELETE;
                }
                case 4: {
                    return METER_DELETE;
                }
                case 5: {
                    return EVICTION;
                }
            }
            return NO_REASON;
        }
    }
}

