/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.annotations.Beta;
import java.util.List;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;

@Beta
public interface FlowObjectiveService {
    public void filter(DeviceId var1, FilteringObjective var2);

    public void forward(DeviceId var1, ForwardingObjective var2);

    public void next(DeviceId var1, NextObjective var2);

    public int allocateNextId();

    public void initPolicy(String var1);

    default public void apply(DeviceId deviceId, Objective objective) {
        if (ForwardingObjective.class.isAssignableFrom(objective.getClass())) {
            this.forward(deviceId, (ForwardingObjective)objective);
        } else if (FilteringObjective.class.isAssignableFrom(objective.getClass())) {
            this.filter(deviceId, (FilteringObjective)objective);
        } else if (NextObjective.class.isAssignableFrom(objective.getClass())) {
            this.next(deviceId, (NextObjective)objective);
        } else {
            throw new UnsupportedOperationException("Unsupported objective of type " + objective.getClass());
        }
    }

    public List<String> getNextMappings();

    public List<String> getPendingFlowObjectives();

    @Deprecated
    public List<String> getPendingNexts();
}

