/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.link;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.net.link.LinkProvider;

public interface ProbedLinkProvider
extends LinkProvider {
    public static final String DEFAULT_MAC = "DE:AD:BE:EF:BA:11";

    public static String defaultMac() {
        return DEFAULT_MAC;
    }

    public static String fingerprintMac(ClusterMetadata cm) {
        if (cm == null) {
            return DEFAULT_MAC;
        }
        HashFunction hf = Hashing.murmur3_32();
        HashCode hc = hf.newHasher().putObject((Object)cm, ClusterMetadata.HASH_FUNNEL).hash();
        int unqf = hc.asInt();
        StringBuilder sb = new StringBuilder();
        sb.append("02:eb");
        for (int i = 0; i < 4; ++i) {
            byte b = (byte)(unqf >> i * 8);
            sb.append(String.format(":%02X", b));
        }
        return sb.toString();
    }
}

