/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiActionParamId;

@Beta
public final class PiActionParam {
    private final PiActionParamId id;
    private final ImmutableByteSequence value;

    public PiActionParam(PiActionParamId id, ImmutableByteSequence value) {
        this.id = (PiActionParamId)((Object)Preconditions.checkNotNull((Object)((Object)id)));
        this.value = (ImmutableByteSequence)Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((value.size() > 0 ? 1 : 0) != 0, (Object)"Value can't have size 0");
    }

    public PiActionParamId id() {
        return this.id;
    }

    public ImmutableByteSequence value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiActionParam that = (PiActionParam)o;
        return Objects.equal((Object)((Object)this.id), (Object)((Object)that.id)) && Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.value});
    }

    public String toString() {
        return this.id.toString() + "=" + this.value().toString();
    }
}

