/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkService;
import org.onosproject.ui.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSelection {
    private static final Logger log = LoggerFactory.getLogger(NodeSelection.class);
    private static final String IDS = "ids";
    private static final String HOVER = "hover";
    private static final String LINK_ID_DELIM = "-";
    private final DeviceService deviceService;
    private final HostService hostService;
    private final LinkService linkService;
    private final Set<String> ids;
    private final String hover;
    private final Set<Device> devices = new HashSet<Device>();
    private final Set<Host> hosts = new HashSet<Host>();
    private final Set<Link> links = new HashSet<Link>();
    private Element hovered;

    public NodeSelection(ObjectNode payload, DeviceService deviceService, HostService hostService, LinkService linkService) {
        this.deviceService = deviceService;
        this.hostService = hostService;
        this.linkService = linkService;
        this.ids = this.extractIds(payload);
        this.hover = this.extractHover(payload);
        if (Strings.isNullOrEmpty((String)this.hover)) {
            this.hovered = null;
        } else {
            this.setHoveredElement();
        }
        Set<String> unmatched = this.findLinks(this.ids);
        unmatched = this.findDevices(unmatched);
        unmatched = this.findHosts(unmatched);
        if (!unmatched.isEmpty()) {
            log.debug("Skipping unmatched IDs {}", unmatched);
        }
    }

    public Set<Device> devices() {
        return Collections.unmodifiableSet(this.devices);
    }

    public Set<Link> links() {
        return Collections.unmodifiableSet(this.links);
    }

    public Set<Device> devicesWithHover() {
        Set<Device> withHover;
        if (this.hovered != null && this.hovered instanceof Device) {
            withHover = new HashSet<Device>(this.devices);
            withHover.add((Device)this.hovered);
        } else {
            withHover = this.devices;
        }
        return Collections.unmodifiableSet(withHover);
    }

    public Set<Host> hosts() {
        return Collections.unmodifiableSet(this.hosts);
    }

    public Set<Host> hostsWithHover() {
        Set<Host> withHover;
        if (this.hovered != null && this.hovered instanceof Host) {
            withHover = new HashSet<Host>(this.hosts);
            withHover.add((Host)this.hovered);
        } else {
            withHover = this.hosts;
        }
        return Collections.unmodifiableSet(withHover);
    }

    public Set<Link> linksWithHover() {
        Set<Link> withHover;
        if (this.hovered != null && this.hovered instanceof Link) {
            withHover = new HashSet<Link>(this.links);
            withHover.add((Link)((Object)this.hovered));
        } else {
            withHover = this.links;
        }
        return Collections.unmodifiableSet(withHover);
    }

    public Element hovered() {
        return this.hovered;
    }

    public boolean none() {
        return this.devices().isEmpty() && this.hosts().isEmpty() && this.links().isEmpty();
    }

    public String toString() {
        return "NodeSelection{ids=" + this.ids + ", hover='" + this.hover + '\'' + ", #devices=" + this.devices.size() + ", #hosts=" + this.hosts.size() + ", #links=" + this.links.size() + '}';
    }

    private Set<String> extractIds(ObjectNode payload) {
        ArrayNode array = (ArrayNode)payload.path(IDS);
        if (array == null || array.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> ids = new HashSet<String>();
        for (JsonNode node : array) {
            ids.add(node.asText());
        }
        return ids;
    }

    private String extractHover(ObjectNode payload) {
        return JsonUtils.string(payload, HOVER);
    }

    private void setHoveredElement() {
        Set<String> unmatched = new HashSet<String>();
        unmatched.add(this.hover);
        unmatched = this.findDevices(unmatched);
        if (this.devices.size() == 1) {
            this.hovered = this.devices.iterator().next();
            this.devices.clear();
        } else {
            unmatched = this.findHosts(unmatched);
            if (this.hosts.size() == 1) {
                this.hovered = this.hosts.iterator().next();
                this.hosts.clear();
            } else {
                this.hovered = null;
                log.debug("Skipping unmatched HOVER {}", unmatched);
            }
        }
    }

    private Set<String> findDevices(Set<String> ids) {
        HashSet<String> unmatched = new HashSet<String>();
        for (String id : ids) {
            try {
                Device device = this.deviceService.getDevice(DeviceId.deviceId(id));
                if (device != null) {
                    this.devices.add(device);
                    continue;
                }
                unmatched.add(id);
            }
            catch (Exception e) {
                unmatched.add(id);
            }
        }
        return unmatched;
    }

    private Set<String> findHosts(Set<String> ids) {
        HashSet<String> unmatched = new HashSet<String>();
        for (String id : ids) {
            try {
                Host host = this.hostService.getHost(HostId.hostId(id));
                if (host != null) {
                    this.hosts.add(host);
                    continue;
                }
                unmatched.add(id);
            }
            catch (Exception e) {
                unmatched.add(id);
            }
        }
        return unmatched;
    }

    private Set<String> findLinks(Set<String> ids) {
        HashSet<String> unmatched = new HashSet<String>();
        for (String id : ids) {
            try {
                ConnectPoint cpDst;
                String[] connectPoints = id.split(LINK_ID_DELIM);
                if (connectPoints.length != 2) {
                    unmatched.add(id);
                    continue;
                }
                ConnectPoint cpSrc = ConnectPoint.deviceConnectPoint(connectPoints[0]);
                Link link = this.linkService.getLink(cpSrc, cpDst = ConnectPoint.deviceConnectPoint(connectPoints[1]));
                if (link != null) {
                    this.links.add(link);
                    continue;
                }
                unmatched.add(id);
            }
            catch (Exception e) {
                unmatched.add(id);
            }
        }
        return unmatched;
    }
}

