/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.Host;
import org.onosproject.net.HostLocation;
import org.onosproject.net.TestDeviceParams;

public class DefaultHostTest
extends TestDeviceParams {
    private static final Set<HostLocation> LOCATIONS = ImmutableSet.of((Object)LOC1, (Object)LOC2, (Object)LOC3);
    private static final Host SINGLE_HOMED_HOST = new DefaultHost(PID, HID1, MAC1, VLAN1, LOC1, IPSET1, new Annotations[0]);
    private static final Host MULTI_HOMED_HOST = new DefaultHost(PID, HID1, MAC1, VLAN1, LOCATIONS, IPSET1, false, new Annotations[0]);

    @Test
    public void testEquality() {
        DefaultHost h1 = new DefaultHost(PID, HID1, MAC1, VLAN1, LOC1, IPSET1, new Annotations[0]);
        DefaultHost h2 = new DefaultHost(PID, HID1, MAC1, VLAN1, LOC1, IPSET1, new Annotations[0]);
        DefaultHost h3 = new DefaultHost(PID, HID2, MAC2, VLAN2, LOC2, IPSET2, new Annotations[0]);
        DefaultHost h4 = new DefaultHost(PID, HID2, MAC2, VLAN2, LOC2, IPSET2, new Annotations[0]);
        DefaultHost h5 = new DefaultHost(PID, HID2, MAC2, VLAN1, LOC2, IPSET1, new Annotations[0]);
        new EqualsTester().addEqualityGroup(new Object[]{h1, h2}).addEqualityGroup(new Object[]{h3, h4}).addEqualityGroup(new Object[]{h5}).testEquals();
    }

    @Test
    public void basics() {
        Assert.assertEquals((String)"incorrect provider", (Object)PID, (Object)SINGLE_HOMED_HOST.providerId());
        Assert.assertEquals((String)"incorrect id", (Object)HID1, (Object)SINGLE_HOMED_HOST.id());
        Assert.assertEquals((String)"incorrect type", (Object)MAC1, (Object)SINGLE_HOMED_HOST.mac());
        Assert.assertEquals((String)"incorrect VLAN", (Object)VLAN1, (Object)SINGLE_HOMED_HOST.vlan());
        Assert.assertEquals((String)"incorrect location", (Object)LOC1, (Object)SINGLE_HOMED_HOST.location());
        Assert.assertEquals((String)"incorrect IPs", (Object)IPSET1, (Object)SINGLE_HOMED_HOST.ipAddresses());
    }

    @Test
    public void testLocation() {
        Assert.assertEquals((String)"Latest location should be LOC3", (Object)LOC3, (Object)MULTI_HOMED_HOST.location());
    }

    @Test
    public void testLocations() {
        Set locations = MULTI_HOMED_HOST.locations();
        Assert.assertEquals((String)"There should be 3 locations", (long)locations.size(), (long)3L);
        Assert.assertTrue((String)"Host location contains 1st location", (boolean)locations.contains(LOC1));
        Assert.assertTrue((String)"Host location contains 2nd location", (boolean)locations.contains(LOC2));
        Assert.assertTrue((String)"Host location contains 3rd location", (boolean)locations.contains(LOC3));
    }
}

