/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ui.topo.BiLinkTestBase;

public class BiLinkMapTest
extends BiLinkTestBase {
    private BiLinkTestBase.ConcreteLink clink;
    private BiLinkTestBase.ConcreteLinkMap linkMap;

    @Before
    public void setUp() {
        this.linkMap = new BiLinkTestBase.ConcreteLinkMap();
    }

    @Test
    public void basic() {
        Assert.assertEquals((String)"wrong map size", (long)0L, (long)this.linkMap.size());
        Assert.assertTrue((String)"unexpected links", (boolean)this.linkMap.biLinks().isEmpty());
    }

    @Test
    public void addSameLinkTwice() {
        this.linkMap.add(LINK_AB);
        Assert.assertEquals((String)"wrong map size", (long)1L, (long)this.linkMap.size());
        this.clink = (BiLinkTestBase.ConcreteLink)((Object)this.linkMap.biLinks().iterator().next());
        Assert.assertEquals((String)"wrong link one", (Object)LINK_AB, (Object)this.clink.one());
        Assert.assertNull((String)"unexpected link two", (Object)this.clink.two());
        this.linkMap.add(LINK_AB);
        Assert.assertEquals((String)"wrong map size", (long)1L, (long)this.linkMap.size());
        this.clink = (BiLinkTestBase.ConcreteLink)((Object)this.linkMap.biLinks().iterator().next());
        Assert.assertEquals((String)"wrong link one", (Object)LINK_AB, (Object)this.clink.one());
        Assert.assertNull((String)"unexpected link two", (Object)this.clink.two());
    }

    @Test
    public void addPairOfLinks() {
        this.linkMap.add(LINK_AB);
        Assert.assertEquals((String)"wrong map size", (long)1L, (long)this.linkMap.size());
        this.clink = (BiLinkTestBase.ConcreteLink)((Object)this.linkMap.biLinks().iterator().next());
        Assert.assertEquals((String)"wrong link one", (Object)LINK_AB, (Object)this.clink.one());
        Assert.assertNull((String)"unexpected link two", (Object)this.clink.two());
        this.linkMap.add(LINK_BA);
        Assert.assertEquals((String)"wrong map size", (long)1L, (long)this.linkMap.size());
        this.clink = (BiLinkTestBase.ConcreteLink)((Object)this.linkMap.biLinks().iterator().next());
        Assert.assertEquals((String)"wrong link one", (Object)LINK_AB, (Object)this.clink.one());
        Assert.assertEquals((String)"wrong link two", (Object)LINK_BA, (Object)this.clink.two());
    }
}

