/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.IllegalDocumentNameException;

public class DocumentPathTest {
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testConstruction() {
        DocumentPath path = DocumentPathTest.path("root.a.b");
        Assert.assertEquals((Object)path.pathElements(), Arrays.asList("root", "a", "b"));
        Assert.assertEquals((Object)DocumentPathTest.path("root.a"), (Object)path.parent());
        Assert.assertEquals((Object)DocumentPathTest.path("b"), (Object)path.childPath());
        path = DocumentPath.from((String[])new String[]{"root", "a", "b"});
        Assert.assertEquals((Object)path.pathElements(), Arrays.asList("root", "a", "b"));
    }

    @Test
    public void testAncestry() {
        DocumentPath path = DocumentPathTest.path("root");
        Assert.assertEquals((Object)path.childPath(), null);
        DocumentPath path1 = DocumentPathTest.path("root.a.b");
        DocumentPath path2 = DocumentPathTest.path("root.a.d");
        DocumentPath path3 = DocumentPathTest.path("root.a.b.c");
        DocumentPath lca = DocumentPath.leastCommonAncestor(Arrays.asList(path1, path2, path3));
        Assert.assertEquals((Object)DocumentPathTest.path("root.a"), (Object)lca);
        Assert.assertTrue((boolean)path1.isAncestorOf(path3));
        Assert.assertFalse((boolean)path1.isAncestorOf(path2));
        Assert.assertTrue((boolean)path3.isDescendentOf(path3));
        Assert.assertTrue((boolean)path3.isDescendentOf(path1));
        Assert.assertFalse((boolean)path3.isDescendentOf(path2));
    }

    @Test
    public void testExceptions() {
        DocumentPath parentPath = DocumentPathTest.path("root.a.b");
        DocumentPath path2 = DocumentPathTest.exceptions("nodeName", parentPath);
        this.exception.expect(IllegalDocumentNameException.class);
        DocumentPath path1 = DocumentPathTest.exceptions("node|name", parentPath);
    }

    @Test
    public void comparePaths() {
        DocumentPath one = DocumentPathTest.path("root");
        DocumentPath four = DocumentPathTest.path("root.a.b.c.d");
        DocumentPath difFour = DocumentPathTest.path("root.e.c.b.a");
        Assert.assertThat((Object)one.compareTo(four), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)four.compareTo(one), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)difFour.compareTo(four), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)difFour.compareTo(difFour), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    private static DocumentPath exceptions(String nodeName, DocumentPath path) {
        return new DocumentPath(nodeName, path);
    }

    private static DocumentPath path(String path) {
        return DocumentPath.from((String)path.replace(".", "|"));
    }
}

