/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.onosproject.net.pi.model.PiActionGroupType;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiActionGroupId;
import org.onosproject.net.pi.runtime.PiActionGroupMember;
import org.onosproject.net.pi.runtime.PiActionGroupMemberId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;

@Beta
public final class PiActionGroup
implements PiEntity {
    private final PiActionGroupId id;
    private final PiActionGroupType type;
    private final ImmutableSet<PiActionGroupMember> members;
    private final PiActionProfileId piActionProfileId;

    private PiActionGroup(PiActionGroupId id, PiActionGroupType type, ImmutableSet<PiActionGroupMember> members, PiActionProfileId piActionProfileId) {
        this.id = id;
        this.type = type;
        this.members = members;
        this.piActionProfileId = piActionProfileId;
    }

    public PiActionGroupId id() {
        return this.id;
    }

    public PiActionGroupType type() {
        return this.type;
    }

    public Collection<PiActionGroupMember> members() {
        return this.members;
    }

    public PiActionProfileId actionProfileId() {
        return this.piActionProfileId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PiActionGroup)) {
            return false;
        }
        PiActionGroup that = (PiActionGroup)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal(this.members, that.members) && Objects.equal((Object)((Object)this.piActionProfileId), (Object)((Object)that.piActionProfileId));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.type, this.members});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupId", (Object)this.id).add("type", (Object)this.type).add("members", this.members).add("piActionProfileId", (Object)this.piActionProfileId).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.GROUP;
    }

    public static final class Builder {
        private PiActionGroupId id;
        private PiActionGroupType type;
        private Map<PiActionGroupMemberId, PiActionGroupMember> members = Maps.newHashMap();
        private PiActionProfileId piActionProfileId;

        private Builder() {
        }

        public Builder withId(PiActionGroupId id) {
            this.id = id;
            return this;
        }

        public Builder withType(PiActionGroupType type) {
            this.type = type;
            return this;
        }

        public Builder addMember(PiActionGroupMember member) {
            this.members.put(member.id(), member);
            return this;
        }

        public Builder addMembers(Collection<PiActionGroupMember> members) {
            members.forEach(this::addMember);
            return this;
        }

        public Builder withActionProfileId(PiActionProfileId piActionProfileId) {
            this.piActionProfileId = piActionProfileId;
            return this;
        }

        public PiActionGroup build() {
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)((Object)this.type));
            Preconditions.checkArgument((!this.members.isEmpty() ? 1 : 0) != 0, (Object)"Members cannot be empty");
            Preconditions.checkNotNull((Object)((Object)this.piActionProfileId));
            return new PiActionGroup(this.id, this.type, ImmutableSet.copyOf(this.members.values()), this.piActionProfileId);
        }
    }
}

