/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.concurrent.TimeUnit;
import org.onosproject.store.primitives.DistributedPrimitiveBuilder;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedPrimitive;

public abstract class LeaderElectorBuilder
extends DistributedPrimitiveBuilder<LeaderElectorBuilder, AsyncLeaderElector> {
    private long electionTimeoutMillis = 15000L;

    public LeaderElectorBuilder() {
        super(DistributedPrimitive.Type.LEADER_ELECTOR);
    }

    public LeaderElectorBuilder withElectionTimeout(long electionTimeoutMillis) {
        this.electionTimeoutMillis = electionTimeoutMillis;
        return this;
    }

    public LeaderElectorBuilder withElectionTimeout(long electionTimeout, TimeUnit timeUnit) {
        return this.withElectionTimeout(timeUnit.toMillis(electionTimeout));
    }

    public final long electionTimeoutMillis() {
        return this.electionTimeoutMillis;
    }
}

