/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.store.service.Versioned;

public class MapEvent<K, V> {
    private final String name;
    private final Type type;
    private final K key;
    private final Versioned<V> newValue;
    private final Versioned<V> oldValue;

    public MapEvent(String name, K key, Versioned<V> currentValue, Versioned<V> previousValue) {
        this(currentValue != null ? (previousValue != null ? Type.UPDATE : Type.INSERT) : Type.REMOVE, name, key, currentValue, previousValue);
    }

    public MapEvent(Type type, String name, K key, Versioned<V> currentValue, Versioned<V> previousValue) {
        this.type = type;
        this.name = name;
        this.key = key;
        this.newValue = currentValue;
        this.oldValue = previousValue;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public K key() {
        return this.key;
    }

    @Deprecated
    public Versioned<V> value() {
        return this.type == Type.REMOVE ? this.oldValue() : this.newValue();
    }

    public Versioned<V> newValue() {
        return this.newValue;
    }

    public Versioned<V> oldValue() {
        return this.oldValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapEvent)) {
            return false;
        }
        MapEvent that = (MapEvent)o;
        return Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.key, that.key) && Objects.equals(this.newValue, that.newValue) && Objects.equals(this.oldValue, that.oldValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.key, this.newValue, this.oldValue});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("type", (Object)this.type).add("key", this.key).add("newValue", this.newValue).add("oldValue", this.oldValue).toString();
    }

    public static enum Type {
        INSERT,
        UPDATE,
        REMOVE;

    }
}

