/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.service.MapEvent;

public interface Serializer {
    public <T> byte[] encode(T var1);

    public <T> T decode(byte[] var1);

    public <T> T copy(T var1);

    public static Serializer using(final KryoNamespace kryo) {
        return new Serializer(){

            @Override
            public <T> byte[] encode(T object) {
                return kryo.serialize(object);
            }

            @Override
            public <T> T decode(byte[] bytes) {
                return (T)kryo.deserialize(bytes);
            }

            @Override
            public <T> T copy(T object) {
                return (T)kryo.run(k -> k.copy(object));
            }
        };
    }

    public static Serializer using(KryoNamespace namespace, Class<?> ... classes) {
        return Serializer.using(Arrays.asList(namespace), classes);
    }

    public static Serializer using(List<KryoNamespace> namespaces, Class<?> ... classes) {
        KryoNamespace.Builder builder = new KryoNamespace.Builder();
        namespaces.forEach(arg_0 -> ((KryoNamespace.Builder)builder).register(arg_0));
        Lists.newArrayList((Object[])classes).forEach(xva$0 -> builder.register(new Class[]{xva$0}));
        final KryoNamespace namespace = builder.build();
        return new Serializer(){

            @Override
            public <T> byte[] encode(T object) {
                return namespace.serialize(object);
            }

            @Override
            public <T> T decode(byte[] bytes) {
                return (T)namespace.deserialize(bytes);
            }

            @Override
            public <T> T copy(T object) {
                return (T)namespace.run(kryo -> kryo.copy(object));
            }
        };
    }

    public static Serializer forTypes(Class<?> ... classes) {
        return Serializer.using(KryoNamespace.newBuilder().register((Class[])classes).register(new Class[]{MapEvent.class, MapEvent.Type.class}).build());
    }
}

