/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDisjointPath;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;

public class DefaultDisjointPathTest {
    private static DefaultLink link1 = DefaultLink.builder().type(Link.Type.DIRECT).providerId(NetTestTools.PID).src(NetTestTools.connectPoint("dev1", 1)).dst(NetTestTools.connectPoint("dev2", 1)).build();
    private static DefaultLink link2 = DefaultLink.builder().type(Link.Type.DIRECT).providerId(NetTestTools.PID).src(NetTestTools.connectPoint("dev1", 1)).dst(NetTestTools.connectPoint("dev2", 1)).build();
    private static DefaultLink link3 = DefaultLink.builder().type(Link.Type.DIRECT).providerId(NetTestTools.PID).src(NetTestTools.connectPoint("dev2", 1)).dst(NetTestTools.connectPoint("dev3", 1)).build();
    private static List<Link> links1 = ImmutableList.of((Object)link1, (Object)link2);
    private static DefaultPath path1 = new DefaultPath(NetTestTools.PID, links1, 1.0, new Annotations[0]);
    private static List<Link> links2 = ImmutableList.of((Object)link2, (Object)link1);
    private static DefaultPath path2 = new DefaultPath(NetTestTools.PID, links2, 2.0, new Annotations[0]);
    private static List<Link> links3 = ImmutableList.of((Object)link1, (Object)link2, (Object)link3);
    private static DefaultPath path3 = new DefaultPath(NetTestTools.PID, links3, 3.0, new Annotations[0]);
    private static DefaultDisjointPath disjointPath1 = new DefaultDisjointPath(NetTestTools.PID, path1, path2);
    private static DefaultDisjointPath sameAsDisjointPath1 = new DefaultDisjointPath(NetTestTools.PID, path1, path2);
    private static DefaultDisjointPath disjointPath2 = new DefaultDisjointPath(NetTestTools.PID, path2, path1);
    private static DefaultDisjointPath disjointPath3 = new DefaultDisjointPath(NetTestTools.PID, path1, path3);
    private static DefaultDisjointPath disjointPath4 = new DefaultDisjointPath(NetTestTools.PID, path1, null);

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)disjointPath1.primary(), (Matcher)Matchers.is((Object)path1));
        MatcherAssert.assertThat((Object)disjointPath1.backup(), (Matcher)Matchers.is((Object)path2));
        MatcherAssert.assertThat((Object)disjointPath1.links(), (Matcher)Matchers.is(links1));
        MatcherAssert.assertThat((Object)disjointPath1.cost(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{disjointPath1, sameAsDisjointPath1, disjointPath2}).addEqualityGroup(new Object[]{disjointPath3}).addEqualityGroup(new Object[]{disjointPath4}).testEquals();
    }
}

