/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.collect.ImmutableMap;
import com.google.common.testing.EqualsTester;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.behaviour.MirroringStatistics;

public class MirroringStatisticsTest {
    private static final long BYTES_1 = 100L;
    private static final long PACKETS_1 = 2L;
    private static final String NAME_1 = "mirror1";
    private Map<String, Integer> statistics1 = ImmutableMap.of((Object)"tx_bytes", (Object)100, (Object)"tx_packets", (Object)2);
    private MirroringStatistics mirrorStatisticStats1 = MirroringStatistics.mirroringStatistics((String)"mirror1", this.statistics1);
    private Map<String, Integer> sameAsStatistics1 = ImmutableMap.of((Object)"tx_bytes", (Object)100, (Object)"tx_packets", (Object)2);
    private MirroringStatistics sameAsMirrorStatisticStats1 = MirroringStatistics.mirroringStatistics((String)"mirror1", this.sameAsStatistics1);
    private static final long BYTES_2 = 100L;
    private static final long PACKETS_2 = 2L;
    private static final String NAME_2 = "mirror2";
    private Map<String, Integer> statistics2 = ImmutableMap.of((Object)"tx_bytes", (Object)100, (Object)"tx_packets", (Object)2);
    private MirroringStatistics mirrorStatisticStats2 = MirroringStatistics.mirroringStatistics((String)"mirror2", this.statistics2);
    private static final long BYTES_3 = 100L;
    private static final long PACKETS_3 = 2L;
    private static final String NAME_3 = "mirror3";
    private Map<String, Integer> statistics3 = ImmutableMap.of((Object)"tx_bytes", (Object)100, (Object)"tx_packets", (Object)2);
    private MirroringStatistics mirrorStatisticStats3 = MirroringStatistics.mirroringStatistics((String)"mirror3", this.statistics3);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(MirroringStatistics.class);
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.mirrorStatisticStats1.bytes(), (Matcher)Matchers.is((Object)100L));
        MatcherAssert.assertThat((Object)this.mirrorStatisticStats1.name().name(), (Matcher)Matchers.is((Object)NAME_1));
        MatcherAssert.assertThat((Object)this.mirrorStatisticStats1.packets(), (Matcher)Matchers.is((Object)2L));
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.mirrorStatisticStats1, this.sameAsMirrorStatisticStats1}).addEqualityGroup(new Object[]{this.mirrorStatisticStats2}).addEqualityGroup(new Object[]{this.mirrorStatisticStats3}).testEquals();
    }
}

