/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiActionId;
import org.onosproject.net.pi.model.PiActionParamId;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionGroupMember;
import org.onosproject.net.pi.runtime.PiActionGroupMemberId;
import org.onosproject.net.pi.runtime.PiActionParam;

public class PiActionGroupMemberTest {
    private final PiActionGroupMemberId piActionGroupMemberId = PiActionGroupMemberId.of((int)10);
    private final PiAction piAction = PiAction.builder().withId(PiActionId.of((String)"mod_nw_dst")).withParameter(new PiActionParam(PiActionParamId.of((String)"dstAddr"), ImmutableByteSequence.copyFrom((int)0xA010101))).build();
    private final PiActionGroupMember piActionGroupMember1 = PiActionGroupMember.builder().withId(this.piActionGroupMemberId).withAction(this.piAction).withWeight(10).build();
    private final PiActionGroupMember sameAsPiActionGroupMember1 = PiActionGroupMember.builder().withId(this.piActionGroupMemberId).withAction(this.piAction).withWeight(10).build();
    private final PiActionGroupMember piActionGroupMember2 = PiActionGroupMember.builder().withId(this.piActionGroupMemberId).withAction(this.piAction).withWeight(20).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiActionGroupMember.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piActionGroupMember1, this.sameAsPiActionGroupMember1}).addEqualityGroup(new Object[]{this.piActionGroupMember2}).testEquals();
    }

    @Test
    public void testMethods() {
        MatcherAssert.assertThat((Object)this.piActionGroupMember1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.piActionGroupMember1.weight(), (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)this.piActionGroupMember1.id(), (Matcher)Matchers.is((Object)this.piActionGroupMemberId));
        MatcherAssert.assertThat((Object)this.piActionGroupMember1.action(), (Matcher)Matchers.is((Object)this.piAction));
    }
}

