/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiActionGroupType;
import org.onosproject.net.pi.model.PiActionId;
import org.onosproject.net.pi.model.PiActionParamId;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionGroup;
import org.onosproject.net.pi.runtime.PiActionGroupId;
import org.onosproject.net.pi.runtime.PiActionGroupMember;
import org.onosproject.net.pi.runtime.PiActionGroupMemberId;
import org.onosproject.net.pi.runtime.PiActionParam;
import org.onosproject.net.pi.runtime.PiConstantsTest;

public class PiActionGroupTest {
    private final PiActionGroupMemberId piActionGroupMemberId = PiActionGroupMemberId.of((int)10);
    private final PiAction piAction = PiAction.builder().withId(PiActionId.of((String)"mod_nw_dst")).withParameter(new PiActionParam(PiActionParamId.of((String)"dstAddr"), ImmutableByteSequence.copyFrom((int)0xA010101))).build();
    private final PiActionGroupMember piActionGroupMember = PiActionGroupMember.builder().withId(this.piActionGroupMemberId).withAction(this.piAction).withWeight(10).build();
    private PiActionGroupId piActionGroupId = PiActionGroupId.of((int)10);
    private PiActionGroup piActionGroup1 = PiActionGroup.builder().addMember(this.piActionGroupMember).withId(this.piActionGroupId).withType(PiActionGroupType.SELECT).withActionProfileId(PiConstantsTest.ACTION_PROF_ID).build();
    private PiActionGroup sameAsPiActionGroup1 = PiActionGroup.builder().addMember(this.piActionGroupMember).withId(this.piActionGroupId).withType(PiActionGroupType.SELECT).withActionProfileId(PiConstantsTest.ACTION_PROF_ID).build();
    private PiActionGroupId piActionGroupId2 = PiActionGroupId.of((int)20);
    private PiActionGroup piActionGroup2 = PiActionGroup.builder().addMember(this.piActionGroupMember).withId(this.piActionGroupId2).withType(PiActionGroupType.SELECT).withActionProfileId(PiConstantsTest.ACTION_PROF_ID).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiActionGroup.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piActionGroup1, this.sameAsPiActionGroup1}).addEqualityGroup(new Object[]{this.piActionGroup2}).testEquals();
    }

    @Test
    public void testMethods() {
        ArrayList piActionGroupMembers = Lists.newArrayList();
        piActionGroupMembers.add(this.piActionGroupMember);
        MatcherAssert.assertThat((Object)this.piActionGroup1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.piActionGroup1.id(), (Matcher)Matchers.is((Object)this.piActionGroupId));
        MatcherAssert.assertThat((Object)this.piActionGroup1.type(), (Matcher)Matchers.is((Object)PiActionGroupType.SELECT));
        MatcherAssert.assertThat((String)"Incorrect members value", (boolean)CollectionUtils.isEqualCollection((Collection)this.piActionGroup1.members(), (Collection)piActionGroupMembers));
    }
}

