/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.annotations.Beta;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import org.onlab.util.Identifier;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceConsumerId;

@Beta
public final class ResourceGroup
extends Identifier<Long>
implements ResourceConsumer {
    private static final String HEX_PREFIX = "0x";
    private static final HashFunction HASH_FN = Hashing.md5();

    public static ResourceGroup of(long value) {
        return new ResourceGroup(value);
    }

    public static ResourceGroup of(String value) {
        return new ResourceGroup(HASH_FN.newHasher().putString((CharSequence)value, StandardCharsets.UTF_8).hash().asLong());
    }

    protected ResourceGroup() {
        super((Object)0L);
    }

    protected ResourceGroup(long value) {
        super((Object)value);
    }

    public long fingerprint() {
        return (Long)this.identifier;
    }

    public String toString() {
        return HEX_PREFIX + Long.toHexString((Long)this.identifier);
    }

    @Override
    public ResourceConsumerId consumerId() {
        return ResourceConsumerId.of(this);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceGroup other = (ResourceGroup)obj;
        return this.fingerprint() == other.fingerprint();
    }
}

