/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.store.primitives.DefaultConsistentMap;
import org.onosproject.store.service.AsyncConsistentMapAdapter;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Versioned;

public class DefaultConsistentMapTest {
    private static final int DEFAULT_CREATION_TIME = 0;
    private static final int DEFAULT_VERSION = 0;
    private static final String KEY1 = "AAA";
    private static final String VALUE1 = "111";
    private static final String KEY2 = "BBB";
    private static final String VALUE2 = "222";
    private static final String KEY3 = "CCC";
    private static final String VALUE3 = "333";
    private static final String KEY4 = "DDD";
    private static final String VALUE4 = "444";
    private int computeFunctionCalls = 0;

    private String computeFunction(String s) {
        ++this.computeFunctionCalls;
        if (KEY4.equals(s)) {
            return VALUE4;
        }
        return "";
    }

    @Test
    public void testBehavior() {
        HashMap baseMap = new HashMap();
        AsyncConsistentMapMock asyncMap = new AsyncConsistentMapMock(baseMap);
        DefaultConsistentMap newMap = new DefaultConsistentMap(asyncMap, 11L);
        MatcherAssert.assertThat((Object)newMap.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)newMap.isEmpty(), (Matcher)Matchers.is((Object)true));
        newMap.put((Object)KEY1, (Object)VALUE1);
        MatcherAssert.assertThat((Object)newMap.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY1).value(), (Matcher)Matchers.is((Object)VALUE1));
        MatcherAssert.assertThat((Object)newMap.containsKey((Object)KEY1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newMap.containsKey((Object)VALUE1), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)newMap.containsValue((Object)VALUE1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newMap.containsValue((Object)KEY1), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)newMap.keySet(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)newMap.keySet(), (Matcher)CoreMatchers.hasItem((Object)KEY1));
        MatcherAssert.assertThat((Object)newMap.values(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)newMap.values(), (Matcher)CoreMatchers.hasItem((Object)new Versioned((Object)VALUE1, 0L, 0L)));
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)1));
        Map.Entry entry = (Map.Entry)newMap.entrySet().iterator().next();
        MatcherAssert.assertThat(entry.getKey(), (Matcher)Matchers.is((Object)KEY1));
        MatcherAssert.assertThat((Object)((Versioned)entry.getValue()).value(), (Matcher)Matchers.is((Object)VALUE1));
        newMap.putIfAbsent((Object)KEY2, (Object)VALUE2);
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY2).value(), (Matcher)Matchers.is((Object)VALUE2));
        newMap.putIfAbsent((Object)KEY2, (Object)VALUE1);
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY2).value(), (Matcher)Matchers.is((Object)VALUE2));
        newMap.putAndGet((Object)KEY3, (Object)VALUE3);
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY3).value(), (Matcher)Matchers.is((Object)VALUE3));
        newMap.putIfAbsent((Object)KEY3, (Object)VALUE1);
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY3).value(), (Matcher)Matchers.is((Object)VALUE3));
        MatcherAssert.assertThat((Object)newMap.computeIfAbsent((Object)KEY4, this::computeFunction).value(), (Matcher)Matchers.is((Object)VALUE4));
        MatcherAssert.assertThat((Object)this.computeFunctionCalls, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat((Object)newMap.computeIfAbsent((Object)KEY4, this::computeFunction).value(), (Matcher)Matchers.is((Object)VALUE4));
        MatcherAssert.assertThat((Object)this.computeFunctionCalls, (Matcher)Matchers.is((Object)1));
        Map javaMap = newMap.asJavaMap();
        MatcherAssert.assertThat((Object)javaMap.size(), (Matcher)Matchers.is((Object)newMap.size()));
        MatcherAssert.assertThat(javaMap.get(KEY1), (Matcher)Matchers.is((Object)VALUE1));
        MatcherAssert.assertThat((Object)newMap.toString(), (Matcher)Matchers.containsString((String)"DDD=444"));
        MatcherAssert.assertThat((Object)newMap.remove((Object)KEY4).value(), (Matcher)Matchers.is((Object)VALUE4));
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)newMap.remove((Object)KEY4).value(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)newMap.remove((Object)KEY3, 0L), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)newMap.remove((Object)KEY3, 0L), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)newMap.remove((Object)KEY2, (Object)VALUE2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)newMap.remove((Object)KEY2, (Object)VALUE2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)newMap.entrySet(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)newMap.replace((Object)KEY1, (Object)VALUE4).value(), (Matcher)Matchers.is((Object)VALUE1));
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY1).value(), (Matcher)Matchers.is((Object)VALUE4));
        MatcherAssert.assertThat((Object)newMap.replace((Object)KEY1, (Object)VALUE4, (Object)VALUE2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY1).value(), (Matcher)Matchers.is((Object)VALUE2));
        MatcherAssert.assertThat((Object)newMap.replace((Object)KEY1, 0L, (Object)VALUE1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY1).value(), (Matcher)Matchers.is((Object)VALUE1));
        newMap.clear();
        MatcherAssert.assertThat((Object)newMap.size(), (Matcher)Matchers.is((Object)0));
        newMap.compute((Object)KEY1, (a, b) -> VALUE1);
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY1).value(), (Matcher)Matchers.is((Object)VALUE1));
        newMap.computeIfPresent((Object)KEY1, (a, b) -> VALUE2);
        MatcherAssert.assertThat((Object)newMap.get((Object)KEY1).value(), (Matcher)Matchers.is((Object)VALUE2));
        Listener listener1 = new Listener(1);
        newMap.addListener((MapEventListener)listener1, null);
        MatcherAssert.assertThat((Object)asyncMap.listeners, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)asyncMap.listeners, (Matcher)CoreMatchers.hasItem((Object)listener1));
        newMap.removeListener((MapEventListener)listener1);
        MatcherAssert.assertThat((Object)asyncMap.listeners, (Matcher)Matchers.hasSize((int)0));
        Consumer<DistributedPrimitive.Status> consumer = status -> {};
        newMap.addStatusChangeListener(consumer);
        MatcherAssert.assertThat((Object)newMap.statusChangeListeners(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)newMap.statusChangeListeners(), (Matcher)CoreMatchers.hasItem(consumer));
        newMap.removeStatusChangeListener(consumer);
        MatcherAssert.assertThat((Object)newMap.statusChangeListeners(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)newMap.statusChangeListeners(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem(consumer)));
    }

    class Listener
    implements MapEventListener<String, String> {
        final int id;

        Listener(int newId) {
            this.id = newId;
        }

        public void event(MapEvent<String, String> event) {
        }
    }

    public class AsyncConsistentMapMock<K, V>
    extends AsyncConsistentMapAdapter<K, V> {
        private final List<MapEventListener<K, V>> listeners;
        Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners = new ArrayList<Consumer<DistributedPrimitive.Status>>();
        private final Map<K, V> baseMap;

        Versioned<V> makeVersioned(V v) {
            return new Versioned(v, 0L, 0L);
        }

        AsyncConsistentMapMock(Map<K, V> newBaseMap) {
            this.baseMap = newBaseMap;
            this.listeners = new ArrayList<MapEventListener<K, V>>();
        }

        @Override
        public CompletableFuture<Integer> size() {
            return CompletableFuture.completedFuture(this.baseMap.size());
        }

        @Override
        public CompletableFuture<Boolean> containsKey(K key) {
            return CompletableFuture.completedFuture(this.baseMap.containsKey(key));
        }

        @Override
        public CompletableFuture<Boolean> containsValue(V value) {
            return CompletableFuture.completedFuture(this.baseMap.containsValue(value));
        }

        @Override
        public CompletableFuture<Versioned<V>> get(K key) {
            return CompletableFuture.completedFuture(this.makeVersioned(this.baseMap.get(key)));
        }

        @Override
        public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            V value = this.baseMap.get(key);
            if (condition.test(value)) {
                value = this.baseMap.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
            }
            return CompletableFuture.completedFuture(this.makeVersioned(value));
        }

        @Override
        public CompletableFuture<Versioned<V>> put(K key, V value) {
            return CompletableFuture.completedFuture(this.makeVersioned(this.baseMap.put(key, value)));
        }

        @Override
        public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
            return CompletableFuture.completedFuture(this.makeVersioned(this.baseMap.put(key, value)));
        }

        @Override
        public CompletableFuture<Versioned<V>> remove(K key) {
            return CompletableFuture.completedFuture(this.makeVersioned(this.baseMap.remove(key)));
        }

        @Override
        public CompletableFuture<Void> clear() {
            this.baseMap.clear();
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }

        @Override
        public CompletableFuture<Set<K>> keySet() {
            return CompletableFuture.completedFuture(this.baseMap.keySet());
        }

        @Override
        public CompletableFuture<Collection<Versioned<V>>> values() {
            Set valuesAsVersionedCollection = this.baseMap.values().stream().map(this::makeVersioned).collect(Collectors.toSet());
            return CompletableFuture.completedFuture(valuesAsVersionedCollection);
        }

        @Override
        public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet() {
            HashMap valuesAsVersionedMap = new HashMap();
            this.baseMap.entrySet().forEach(e -> valuesAsVersionedMap.put(e.getKey(), this.makeVersioned(e.getValue())));
            return CompletableFuture.completedFuture(valuesAsVersionedMap.entrySet());
        }

        @Override
        public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
            return CompletableFuture.completedFuture(this.makeVersioned(this.baseMap.putIfAbsent(key, value)));
        }

        @Override
        public CompletableFuture<Boolean> remove(K key, V value) {
            return CompletableFuture.completedFuture(this.baseMap.remove(key, value));
        }

        @Override
        public CompletableFuture<Boolean> remove(K key, long version) {
            V value = this.baseMap.remove(key);
            return CompletableFuture.completedFuture(value != null);
        }

        @Override
        public CompletableFuture<Versioned<V>> replace(K key, V value) {
            return CompletableFuture.completedFuture(this.makeVersioned(this.baseMap.replace(key, value)));
        }

        @Override
        public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
            return CompletableFuture.completedFuture(this.baseMap.replace(key, oldValue, newValue));
        }

        @Override
        public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
            return CompletableFuture.completedFuture(this.baseMap.replace(key, newValue) != null);
        }

        @Override
        public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor e) {
            this.listeners.add(listener);
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }

        @Override
        public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
            this.listeners.remove(listener);
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }

        public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
            this.statusChangeListeners.add(listener);
        }

        public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
            this.statusChangeListeners.remove(listener);
        }

        public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
            return this.statusChangeListeners;
        }
    }
}

