/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onosproject.store.primitives.ConsistentMapBackedJavaMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapAdapter;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Versioned;

public final class TestConsistentMap<K, V>
extends ConsistentMapAdapter<K, V> {
    private final List<MapEventListener<K, V>> listeners;
    private final Map<K, Versioned<V>> map;
    private final String mapName;
    private final AtomicLong counter = new AtomicLong(0L);
    private final Serializer serializer;

    private TestConsistentMap(String mapName, Serializer serializer) {
        this.map = new HashMap<K, Versioned<V>>();
        this.listeners = new LinkedList<MapEventListener<K, V>>();
        this.mapName = mapName;
        this.serializer = serializer;
    }

    private Versioned<V> version(V v) {
        return new Versioned(v, this.counter.incrementAndGet(), System.currentTimeMillis());
    }

    private void notifyListeners(String mapName, K key, Versioned<V> newvalue, Versioned<V> oldValue) {
        MapEvent event = new MapEvent(mapName, key, newvalue, oldValue);
        this.listeners.forEach(listener -> listener.event(event));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return this.map.containsValue(value);
    }

    @Override
    public Versioned<V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public Versioned<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        AtomicBoolean updated = new AtomicBoolean(false);
        Versioned result = this.map.compute(key, (k, v) -> {
            if (v == null) {
                updated.set(true);
                return this.version(mappingFunction.apply((K)key));
            }
            return v;
        });
        if (updated.get()) {
            this.notifyListeners(this.mapName, key, result, null);
        }
        return result;
    }

    @Override
    public Versioned<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        AtomicBoolean updated = new AtomicBoolean(false);
        AtomicReference previousValue = new AtomicReference();
        Versioned result = this.map.compute(key, (k, v) -> {
            updated.set(true);
            previousValue.set(this.serializer.decode(this.serializer.encode(v)));
            return this.version(remappingFunction.apply((K)k, (V)Versioned.valueOrNull((Versioned)v)));
        });
        if (updated.get()) {
            this.notifyListeners(this.mapName, key, result, (Versioned)previousValue.get());
        }
        return result;
    }

    @Override
    public Versioned<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        AtomicBoolean updated = new AtomicBoolean(false);
        AtomicReference previousValue = new AtomicReference();
        Versioned result = this.map.compute(key, (k, v) -> {
            if (v != null) {
                updated.set(true);
                previousValue.set(this.serializer.decode(this.serializer.encode(v)));
                return this.version(remappingFunction.apply((K)k, (V)v.value()));
            }
            return v;
        });
        if (updated.get()) {
            this.notifyListeners(this.mapName, key, result, (Versioned)previousValue.get());
        }
        return result;
    }

    @Override
    public Versioned<V> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        AtomicBoolean updated = new AtomicBoolean(false);
        AtomicReference previousValue = new AtomicReference();
        Versioned result = this.map.compute(key, (k, v) -> {
            if (condition.test((V)Versioned.valueOrNull((Versioned)v))) {
                previousValue.set(this.serializer.decode(this.serializer.encode(v)));
                updated.set(true);
                return this.version(remappingFunction.apply((K)k, (V)Versioned.valueOrNull((Versioned)v)));
            }
            return v;
        });
        if (updated.get()) {
            this.notifyListeners(this.mapName, key, result, (Versioned)previousValue.get());
        }
        return result;
    }

    @Override
    public Versioned<V> put(K key, V value) {
        Versioned<V> newValue = this.version(value);
        Versioned<V> previousValue = this.map.put(key, newValue);
        this.notifyListeners(this.mapName, key, newValue, previousValue);
        return previousValue;
    }

    @Override
    public Versioned<V> putAndGet(K key, V value) {
        Versioned<V> newValue = this.version(value);
        Versioned<V> previousValue = this.map.put(key, newValue);
        this.notifyListeners(this.mapName, key, newValue, previousValue);
        return newValue;
    }

    @Override
    public Versioned<V> remove(K key) {
        Versioned<V> result = this.map.remove(key);
        this.notifyListeners(this.mapName, key, null, result);
        return result;
    }

    @Override
    public void clear() {
        this.map.keySet().forEach(this::remove);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Versioned<V>> values() {
        return this.map.values().stream().collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<K, Versioned<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Versioned<V> putIfAbsent(K key, V value) {
        Versioned<V> newValue = this.version(value);
        Versioned<V> result = this.map.putIfAbsent(key, newValue);
        if (result == null) {
            this.notifyListeners(this.mapName, key, newValue, result);
        }
        return result;
    }

    @Override
    public boolean remove(K key, V value) {
        Versioned<V> existingValue = this.map.get(key);
        if (Objects.equal((Object)Versioned.valueOrNull(existingValue), value)) {
            this.map.remove(key);
            this.notifyListeners(this.mapName, key, null, existingValue);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(K key, long version) {
        Versioned<V> existingValue = this.map.get(key);
        if (existingValue == null) {
            return false;
        }
        if (existingValue.version() == version) {
            this.map.remove(key);
            this.notifyListeners(this.mapName, key, null, existingValue);
            return true;
        }
        return false;
    }

    @Override
    public Versioned<V> replace(K key, V value) {
        Versioned<V> existingValue = this.map.get(key);
        if (existingValue == null) {
            return null;
        }
        Versioned<V> newValue = this.version(value);
        Versioned<V> result = this.map.put(key, newValue);
        this.notifyListeners(this.mapName, key, newValue, result);
        return result;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Versioned<V> existingValue = this.map.get(key);
        if (existingValue == null || !existingValue.value().equals(oldValue)) {
            return false;
        }
        Versioned<V> value = this.version(newValue);
        Versioned<V> result = this.map.put(key, value);
        this.notifyListeners(this.mapName, key, value, result);
        return true;
    }

    @Override
    public boolean replace(K key, long oldVersion, V newValue) {
        Versioned<V> existingValue = this.map.get(key);
        if (existingValue == null || existingValue.version() != oldVersion) {
            return false;
        }
        Versioned<V> value = this.version(newValue);
        Versioned<V> result = this.map.put(key, value);
        this.notifyListeners(this.mapName, key, value, result);
        return true;
    }

    public void addListener(MapEventListener<K, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(MapEventListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Map<K, V> asJavaMap() {
        return new ConsistentMapBackedJavaMap((ConsistentMap)this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<K, V>
    extends ConsistentMapBuilder<K, V> {
        public ConsistentMap<K, V> build() {
            return new TestConsistentMap(this.name(), this.serializer());
        }

        public AsyncConsistentMap<K, V> buildAsyncMap() {
            return null;
        }
    }
}

