/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.AbstractElement;
import org.onosproject.net.Annotations;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.provider.ProviderId;

public class DefaultHost
extends AbstractElement
implements Host {
    private final MacAddress mac;
    private final VlanId vlan;
    private final Set<HostLocation> locations;
    private final Set<IpAddress> ips;
    private final boolean configured;
    private final boolean suspended;

    public DefaultHost(ProviderId providerId, HostId id, MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ips, Annotations ... annotations) {
        this(providerId, id, mac, vlan, location, ips, false, annotations);
    }

    public DefaultHost(ProviderId providerId, HostId id, MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ips, boolean configured, Annotations ... annotations) {
        this(providerId, id, mac, vlan, Collections.singleton(location), ips, configured, annotations);
    }

    public DefaultHost(ProviderId providerId, HostId id, MacAddress mac, VlanId vlan, Set<HostLocation> locations, Set<IpAddress> ips, boolean configured, Annotations ... annotations) {
        super(providerId, id, annotations);
        this.mac = mac;
        this.vlan = vlan;
        this.locations = new HashSet<HostLocation>(locations);
        this.ips = new HashSet<IpAddress>(ips);
        this.configured = configured;
        this.suspended = false;
    }

    public DefaultHost(ProviderId providerId, HostId id, MacAddress mac, VlanId vlan, Set<HostLocation> locations, Set<IpAddress> ips, boolean configured, boolean suspended, Annotations ... annotations) {
        super(providerId, id, annotations);
        this.mac = mac;
        this.vlan = vlan;
        this.locations = new HashSet<HostLocation>(locations);
        this.ips = new HashSet<IpAddress>(ips);
        this.configured = configured;
        this.suspended = suspended;
    }

    @Override
    public HostId id() {
        return (HostId)this.id;
    }

    @Override
    public MacAddress mac() {
        return this.mac;
    }

    @Override
    public Set<IpAddress> ipAddresses() {
        return Collections.unmodifiableSet(this.ips);
    }

    @Override
    public HostLocation location() {
        return this.locations.stream().sorted(Comparator.comparingLong(HostLocation::time).reversed()).findFirst().orElse(null);
    }

    @Override
    public Set<HostLocation> locations() {
        return this.locations;
    }

    @Override
    public VlanId vlan() {
        return this.vlan;
    }

    @Override
    public boolean configured() {
        return this.configured;
    }

    @Override
    public boolean suspended() {
        return this.suspended;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.mac, this.vlan, this.locations, this.suspended);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultHost) {
            DefaultHost other = (DefaultHost)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.mac, other.mac) && Objects.equals(this.vlan, other.vlan) && Objects.equals(this.locations, other.locations) && Objects.equals(this.ipAddresses(), other.ipAddresses()) && Objects.equals(this.annotations(), other.annotations()) && Objects.equals(this.suspended, other.suspended);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("mac", (Object)this.mac()).add("vlan", (Object)this.vlan()).add("locations", this.locations()).add("ipAddresses", this.ipAddresses()).add("annotations", (Object)this.annotations()).add("configured", this.configured()).add("suspended", this.suspended()).toString();
    }
}

