/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.protection;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;

@Beta
@Immutable
public class ProtectedTransportEndpointDescription {
    private final List<TransportEndpointDescription> paths;
    private final DeviceId peer;
    private final String fingerprint;

    protected ProtectedTransportEndpointDescription(List<TransportEndpointDescription> paths, DeviceId peer, String fingerprint) {
        this.paths = ImmutableList.copyOf(paths);
        this.peer = (DeviceId)Preconditions.checkNotNull((Object)peer);
        this.fingerprint = (String)Preconditions.checkNotNull((Object)fingerprint);
    }

    public List<TransportEndpointDescription> paths() {
        return this.paths;
    }

    public DeviceId peer() {
        return this.peer;
    }

    public String fingerprint() {
        return this.fingerprint;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("paths", this.paths).add("peer", (Object)this.peer).add("fingerprint", (Object)this.fingerprint).toString();
    }

    public static final ProtectedTransportEndpointDescription buildDescription(List<TransportEndpointDescription> paths, DeviceId peer, String fingerprint) {
        return new ProtectedTransportEndpointDescription(paths, peer, fingerprint);
    }

    public static final ProtectedTransportEndpointDescription of(List<TransportEndpointDescription> paths, DeviceId peer, String fingerprint) {
        return new ProtectedTransportEndpointDescription(paths, peer, fingerprint);
    }
}

