/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging;

import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.onosproject.store.cluster.messaging.Endpoint;

public interface MessagingService {
    public CompletableFuture<Void> sendAsync(Endpoint var1, String var2, byte[] var3);

    default public CompletableFuture<byte[]> sendAndReceive(Endpoint ep, String type, byte[] payload) {
        return this.sendAndReceive(ep, type, payload, Duration.ZERO, MoreExecutors.directExecutor());
    }

    default public CompletableFuture<byte[]> sendAndReceive(Endpoint ep, String type, byte[] payload, Executor executor) {
        return this.sendAndReceive(ep, type, payload, Duration.ZERO, executor);
    }

    default public CompletableFuture<byte[]> sendAndReceive(Endpoint ep, String type, byte[] payload, Duration timeout) {
        return this.sendAndReceive(ep, type, payload, timeout, MoreExecutors.directExecutor());
    }

    public CompletableFuture<byte[]> sendAndReceive(Endpoint var1, String var2, byte[] var3, Duration var4, Executor var5);

    public void registerHandler(String var1, BiConsumer<Endpoint, byte[]> var2, Executor var3);

    public void registerHandler(String var1, BiFunction<Endpoint, byte[], byte[]> var2, Executor var3);

    public void registerHandler(String var1, BiFunction<Endpoint, byte[], CompletableFuture<byte[]>> var2);

    public void unregisterHandler(String var1);
}

