/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.concurrent.CompletableFuture;
import org.onosproject.store.primitives.DefaultAtomicCounterMap;
import org.onosproject.store.service.AtomicCounterMap;
import org.onosproject.store.service.DistributedPrimitive;

public interface AsyncAtomicCounterMap<K>
extends DistributedPrimitive {
    @Override
    default public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.COUNTER_MAP;
    }

    public CompletableFuture<Long> incrementAndGet(K var1);

    public CompletableFuture<Long> decrementAndGet(K var1);

    public CompletableFuture<Long> getAndIncrement(K var1);

    public CompletableFuture<Long> getAndDecrement(K var1);

    public CompletableFuture<Long> addAndGet(K var1, long var2);

    public CompletableFuture<Long> getAndAdd(K var1, long var2);

    public CompletableFuture<Long> get(K var1);

    public CompletableFuture<Long> put(K var1, long var2);

    public CompletableFuture<Long> putIfAbsent(K var1, long var2);

    public CompletableFuture<Boolean> replace(K var1, long var2, long var4);

    public CompletableFuture<Long> remove(K var1);

    public CompletableFuture<Boolean> remove(K var1, long var2);

    public CompletableFuture<Integer> size();

    public CompletableFuture<Boolean> isEmpty();

    public CompletableFuture<Void> clear();

    default public AtomicCounterMap<K> asAtomicCounterMap() {
        return this.asAtomicCounterMap(DistributedPrimitive.DEFAULT_OPERATION_TIMEOUT_MILLIS);
    }

    default public AtomicCounterMap<K> asAtomicCounterMap(long timeoutMillis) {
        return new DefaultAtomicCounterMap(this, timeoutMillis);
    }
}

