/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.concurrent.CompletableFuture;
import org.onosproject.store.primitives.DefaultAtomicValue;
import org.onosproject.store.service.AtomicValue;
import org.onosproject.store.service.AtomicValueEventListener;
import org.onosproject.store.service.DistributedPrimitive;

public interface AsyncAtomicValue<V>
extends DistributedPrimitive {
    @Override
    default public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.VALUE;
    }

    public CompletableFuture<Boolean> compareAndSet(V var1, V var2);

    public CompletableFuture<V> get();

    public CompletableFuture<V> getAndSet(V var1);

    public CompletableFuture<Void> set(V var1);

    public CompletableFuture<Void> addListener(AtomicValueEventListener<V> var1);

    public CompletableFuture<Void> removeListener(AtomicValueEventListener<V> var1);

    default public AtomicValue<V> asAtomicValue(long timeoutMillis) {
        return new DefaultAtomicValue(this, timeoutMillis);
    }

    default public AtomicValue<V> asAtomicValue() {
        return new DefaultAtomicValue(this, DEFAULT_OPERATION_TIMEOUT_MILLIS);
    }
}

