/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.NotThreadSafe;
import org.onosproject.store.primitives.DefaultDocumentTree;
import org.onosproject.store.primitives.NodeUpdate;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTree;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.Transactional;
import org.onosproject.store.service.Versioned;

@NotThreadSafe
public interface AsyncDocumentTree<V>
extends DistributedPrimitive,
Transactional<NodeUpdate<V>> {
    @Override
    default public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.DOCUMENT_TREE;
    }

    public DocumentPath root();

    public CompletableFuture<Map<String, Versioned<V>>> getChildren(DocumentPath var1);

    public CompletableFuture<Versioned<V>> get(DocumentPath var1);

    public CompletableFuture<Versioned<V>> set(DocumentPath var1, V var2);

    public CompletableFuture<Boolean> create(DocumentPath var1, V var2);

    public CompletableFuture<Boolean> createRecursive(DocumentPath var1, V var2);

    public CompletableFuture<Boolean> replace(DocumentPath var1, V var2, long var3);

    public CompletableFuture<Boolean> replace(DocumentPath var1, V var2, V var3);

    public CompletableFuture<Versioned<V>> removeNode(DocumentPath var1);

    public CompletableFuture<Void> addListener(DocumentPath var1, DocumentTreeListener<V> var2);

    public CompletableFuture<Void> removeListener(DocumentTreeListener<V> var1);

    default public CompletableFuture<Void> addListener(DocumentTreeListener<V> listener) {
        return this.addListener(this.root(), listener);
    }

    default public DocumentTree<V> asDocumentTree() {
        return this.asDocumentTree(DistributedPrimitive.DEFAULT_OPERATION_TIMEOUT_MILLIS);
    }

    default public DocumentTree<V> asDocumentTree(long timeoutMillis) {
        return new DefaultDocumentTree(this, timeoutMillis);
    }
}

