/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.onosproject.store.service.IllegalDocumentNameException;

public class DocumentPath
implements Comparable<DocumentPath> {
    public static final String DEFAULT_SEPARATOR = "|";
    public static final String DEFAULT_SEPARATOR_RE = "\\|";
    private static String pathSeparator = "|";
    private static String pathSeparatorRE = "\\|";
    public static final DocumentPath ROOT = DocumentPath.from("root");
    private final List<String> pathElements;

    private DocumentPath(List<String> pathElements) {
        Preconditions.checkNotNull(pathElements);
        this.pathElements = ImmutableList.copyOf(pathElements);
    }

    public DocumentPath(String nodeName, DocumentPath parentPath) {
        Preconditions.checkNotNull((Object)nodeName, (Object)"Node name cannot be null");
        if (nodeName.contains(pathSeparator)) {
            throw new IllegalDocumentNameException("'" + pathSeparator + "' are not allowed in names.");
        }
        this.pathElements = parentPath != null ? ImmutableList.builder().addAll(parentPath.pathElements()).add((Object)nodeName).build() : ImmutableList.of((Object)nodeName);
    }

    public static DocumentPath from(String path) {
        return new DocumentPath(Arrays.asList(path.split(pathSeparatorRE)));
    }

    public static DocumentPath from(String ... elements) {
        return DocumentPath.from(Arrays.asList(elements));
    }

    public static DocumentPath from(List<String> elements) {
        return new DocumentPath(elements);
    }

    public static DocumentPath from(List<String> elements, String child) {
        elements = new ArrayList<String>(elements);
        elements.add(child);
        return DocumentPath.from(elements);
    }

    public DocumentPath childPath() {
        if (this.pathElements.size() <= 1) {
            return null;
        }
        return new DocumentPath(this.pathElements.subList(this.pathElements.size() - 1, this.pathElements.size()));
    }

    public DocumentPath parent() {
        if (this.pathElements.size() <= 1) {
            return null;
        }
        return new DocumentPath(this.pathElements.subList(0, this.pathElements.size() - 1));
    }

    public List<String> pathElements() {
        return this.pathElements;
    }

    public boolean isAncestorOf(DocumentPath other) {
        return this.pathElements.size() < other.pathElements.size() && this.pathElements.equals(other.pathElements.subList(0, this.pathElements.size()));
    }

    public boolean isDescendentOf(DocumentPath other) {
        return other.equals(this) || other.isAncestorOf(this);
    }

    public static DocumentPath leastCommonAncestor(Collection<DocumentPath> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return null;
        }
        DocumentPath first = paths.iterator().next();
        int maxComps = paths.stream().map(DocumentPath::pathElements).mapToInt(List::size).min().orElse(-1);
        for (int i = 0; i < maxComps; ++i) {
            int fi = i;
            String comp = first.pathElements().get(i);
            boolean isAllCommon = paths.stream().map(DocumentPath::pathElements).map(l -> (String)l.get(fi)).allMatch(c -> comp.equals(c));
            if (isAllCommon) continue;
            return i == 0 ? null : DocumentPath.from(first.pathElements.subList(0, i));
        }
        return DocumentPath.from(first.pathElements.subList(0, maxComps));
    }

    public int hashCode() {
        return Objects.hash(this.pathElements);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DocumentPath) {
            DocumentPath that = (DocumentPath)obj;
            return this.pathElements.equals(that.pathElements);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iter = this.pathElements.iterator();
        while (iter.hasNext()) {
            stringBuilder.append(iter.next());
            if (!iter.hasNext()) continue;
            stringBuilder.append(pathSeparator);
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(DocumentPath that) {
        return Comparators.lexicographical(Comparator.naturalOrder()).compare(this.pathElements, that.pathElements);
    }
}

