/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.Version;
import org.onosproject.event.ListenerService;

public interface ClusterService
extends ListenerService<ClusterEvent, ClusterEventListener> {
    public ControllerNode getLocalNode();

    public Set<ControllerNode> getNodes();

    public ControllerNode getNode(NodeId var1);

    public ControllerNode.State getState(NodeId var1);

    public Version getVersion(NodeId var1);

    default public Instant getLastUpdatedInstant(NodeId nodeId) {
        return Optional.ofNullable(this.getLastUpdated(nodeId)).map(BaseDateTime::getMillis).map(Instant::ofEpochMilli).orElse(null);
    }

    @Deprecated
    default public DateTime getLastUpdated(NodeId nodeId) {
        return Optional.ofNullable(this.getLastUpdatedInstant(nodeId)).map(Instant::toEpochMilli).map(DateTime::new).orElse(null);
    }
}

