/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ApiDocProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DOCS = "/apidoc/swagger.json";
    private static final String MODEL = "/apidoc/model.json";
    private final String key;
    private final String name;
    private final ClassLoader classLoader;

    public ApiDocProvider(String key, String name, ClassLoader classLoader) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"Class loader cannot be null");
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public InputStream docs() {
        return this.get(DOCS);
    }

    public InputStream model() {
        return this.get(MODEL);
    }

    private InputStream get(String resource) {
        InputStream stream = this.classLoader.getResourceAsStream(resource);
        if (stream == null) {
            this.log.warn("Unable to find JSON resource {}", (Object)resource);
        }
        return stream;
    }
}

