/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.StoredGroupEntry;

public class DefaultGroup
extends DefaultGroupDescription
implements Group,
StoredGroupEntry {
    private Group.GroupState state;
    private boolean isGroupStateAddedFirstTime;
    private long life;
    private long packets;
    private long bytes;
    private long referenceCount;
    private GroupId id;
    private int age;

    private void initialize(GroupId newId) {
        this.id = newId;
        this.state = Group.GroupState.PENDING_ADD;
        this.life = 0L;
        this.packets = 0L;
        this.bytes = 0L;
        this.referenceCount = 0L;
        this.age = 0;
    }

    public DefaultGroup(GroupId id, GroupDescription groupDesc) {
        super(groupDesc);
        this.initialize(id);
    }

    public DefaultGroup(GroupId id, DeviceId deviceId, GroupDescription.Type type, GroupBuckets buckets) {
        super(deviceId, type, buckets);
        this.initialize(id);
    }

    @Override
    public GroupId id() {
        return this.id;
    }

    @Override
    public Group.GroupState state() {
        return this.state;
    }

    @Override
    public long life() {
        return this.life;
    }

    @Override
    public long packets() {
        return this.packets;
    }

    @Override
    public long bytes() {
        return this.bytes;
    }

    @Override
    public int age() {
        return this.age;
    }

    @Override
    public void setState(Group.GroupState newState) {
        this.state = newState;
    }

    @Override
    public void setLife(long life) {
        this.life = life;
    }

    @Override
    public void setPackets(long packets) {
        this.packets = packets;
    }

    @Override
    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    @Override
    public void setReferenceCount(long referenceCount) {
        this.referenceCount = referenceCount;
        this.age = referenceCount == 0L ? ++this.age : 0;
    }

    @Override
    public long referenceCount() {
        return this.referenceCount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.id});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultGroup) {
            DefaultGroup that = (DefaultGroup)obj;
            return super.equals(obj) && Objects.equals((Object)this.id, (Object)that.id);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("description", (Object)super.toString()).add("groupid", (Object)this.id).add("state", (Object)this.state).add("age", this.age).toString();
    }

    @Override
    public void setIsGroupStateAddedFirstTime(boolean isGroupStateAddedFirstTime) {
        this.isGroupStateAddedFirstTime = isGroupStateAddedFirstTime;
    }

    @Override
    public boolean isGroupStateAddedFirstTime() {
        return this.isGroupStateAddedFirstTime;
    }
}

