/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.table.cell;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.onosproject.ui.table.cell.AbstractCellFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeFormatter
extends AbstractCellFormatter {
    private static final Logger log = LoggerFactory.getLogger(TimeFormatter.class);
    private DateTimeFormatter dtf = new DateTimeFormatterBuilder().appendValue(ChronoField.CLOCK_HOUR_OF_AMPM).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendText(ChronoField.AMPM_OF_DAY).optionalStart().appendLiteral(' ').appendOffset("+HH:MM", "+00:00").toFormatter().withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());

    public TimeFormatter withLocale(Locale locale) {
        this.dtf = this.dtf.withLocale(locale);
        return this;
    }

    public TimeFormatter withZone(ZoneId zone) {
        this.dtf = this.dtf.withZone(zone);
        return this;
    }

    @Deprecated
    public TimeFormatter withZone(DateTimeZone zone) {
        return this.withZone(zone.toTimeZone().toZoneId());
    }

    @Override
    protected String nonNullFormat(Object value) {
        if (value instanceof TemporalAccessor) {
            try {
                return this.dtf.format((TemporalAccessor)value);
            }
            catch (DateTimeException e) {
                log.error("Failed formatting {} [{}]", new Object[]{value, value.getClass().getSimpleName(), e});
                log.warn("dtf zone was {}", (Object)this.dtf.getZone());
                throw e;
            }
        }
        if (value instanceof DateTime) {
            return this.dtf.format(Instant.ofEpochMilli(((DateTime)value).getMillis()));
        }
        return String.valueOf(value);
    }
}

