/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.topo.NodeBadge;

public class NodeBadgeTest {
    private static final String MSG = "a msg";
    private static final String TXT = "text";
    private static final String GID = "glyph-id";
    private static final int NUM = 42;
    private static final String NUM_STR = Integer.toString(42);
    private static final String WR_S = "wrong status";
    private static final String WR_B = "wrong boolean";
    private static final String WR_T = "wrong text";
    private static final String WR_M = "wrong message";
    private static final String WR_SF = "wrong string format";
    private NodeBadge badge;

    private void checkFields(NodeBadge b, NodeBadge.Status s, boolean g, String txt, String msg) {
        Assert.assertEquals((String)WR_S, (Object)s, (Object)b.status());
        Assert.assertEquals((String)WR_B, (Object)g, (Object)b.isGlyph());
        Assert.assertEquals((String)WR_T, (Object)txt, (Object)b.text());
        Assert.assertEquals((String)WR_M, (Object)msg, (Object)b.message());
    }

    @Test
    public void badgeTypes() {
        Assert.assertEquals((String)WR_SF, (Object)"i", (Object)NodeBadge.Status.INFO.code());
        Assert.assertEquals((String)WR_SF, (Object)"w", (Object)NodeBadge.Status.WARN.code());
        Assert.assertEquals((String)WR_SF, (Object)"e", (Object)NodeBadge.Status.ERROR.code());
        Assert.assertEquals((String)"unexpected size", (long)3L, (long)NodeBadge.Status.values().length);
    }

    @Test
    public void textOnly() {
        this.badge = NodeBadge.text((String)TXT);
        this.checkFields(this.badge, NodeBadge.Status.INFO, false, TXT, null);
    }

    @Test
    public void glyphOnly() {
        this.badge = NodeBadge.glyph((String)GID);
        this.checkFields(this.badge, NodeBadge.Status.INFO, true, GID, null);
    }

    @Test
    public void numberOnly() {
        this.badge = NodeBadge.number((int)42);
        this.checkFields(this.badge, NodeBadge.Status.INFO, false, NUM_STR, null);
    }

    @Test
    public void textInfo() {
        this.badge = NodeBadge.text((NodeBadge.Status)NodeBadge.Status.INFO, (String)TXT);
        this.checkFields(this.badge, NodeBadge.Status.INFO, false, TXT, null);
    }

    @Test
    public void glyphWarn() {
        this.badge = NodeBadge.glyph((NodeBadge.Status)NodeBadge.Status.WARN, (String)GID);
        this.checkFields(this.badge, NodeBadge.Status.WARN, true, GID, null);
    }

    @Test
    public void numberError() {
        this.badge = NodeBadge.number((NodeBadge.Status)NodeBadge.Status.ERROR, (int)42);
        this.checkFields(this.badge, NodeBadge.Status.ERROR, false, NUM_STR, null);
    }

    @Test
    public void textInfoMsg() {
        this.badge = NodeBadge.text((NodeBadge.Status)NodeBadge.Status.INFO, (String)TXT, (String)MSG);
        this.checkFields(this.badge, NodeBadge.Status.INFO, false, TXT, MSG);
    }

    @Test
    public void glyphWarnMsg() {
        this.badge = NodeBadge.glyph((NodeBadge.Status)NodeBadge.Status.WARN, (String)GID, (String)MSG);
        this.checkFields(this.badge, NodeBadge.Status.WARN, true, GID, MSG);
    }

    @Test
    public void numberErrorMsg() {
        this.badge = NodeBadge.number((NodeBadge.Status)NodeBadge.Status.ERROR, (int)42, (String)MSG);
        this.checkFields(this.badge, NodeBadge.Status.ERROR, false, NUM_STR, MSG);
    }
}

