/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class UiView {
    private static final String DEFAULT_HELP_PAGE_URL = "https://wiki.onosproject.org/display/ONOS/The+ONOS+Web+GUI";
    private final Category category;
    private final String id;
    private final String label;
    private final String iconId;
    private final String helpPageUrl;

    public UiView(Category category, String id, String label) {
        this(category, id, label, null, null);
    }

    public UiView(Category category, String id, String label, String iconId) {
        this(category, id, label, iconId, null);
    }

    public UiView(Category category, String id, String label, String iconId, String helpPageUrl) {
        this.category = category;
        this.id = id;
        this.label = label;
        this.iconId = iconId;
        this.helpPageUrl = helpPageUrl == null ? DEFAULT_HELP_PAGE_URL : helpPageUrl;
    }

    public Category category() {
        return this.category;
    }

    public String id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public String iconId() {
        return this.iconId;
    }

    public String helpPageUrl() {
        return this.helpPageUrl;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UiView other = (UiView)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("category", (Object)this.category).add("id", (Object)this.id).add("label", (Object)this.label).add("iconId", (Object)this.iconId).toString();
    }

    public static enum Category {
        PLATFORM,
        NETWORK,
        OTHER,
        HIDDEN;

    }
}

