/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.store.primitives.DefaultConsistentMultimap;
import org.onosproject.store.service.AsyncConsistentMultimapAdapter;
import org.onosproject.store.service.ConsistentMultimap;
import org.onosproject.store.service.Versioned;

public class DefaultConsistentMultimapTest {
    private static final String KEY1 = "AAA";
    private static final String VALUE1 = "111";
    private static final String KEY2 = "BBB";
    private static final String VALUE2 = "222";
    private static final String KEY3 = "CCC";
    private static final String VALUE3 = "333";
    private static final String KEY4 = "DDD";
    private static final String VALUE4 = "444";
    private final List<String> allKeys = Lists.newArrayList((Object[])new String[]{"AAA", "BBB", "CCC", "DDD"});
    private final List<String> allValues = Lists.newArrayList((Object[])new String[]{"111", "222", "333", "444"});

    @Test
    public void testBehavior() {
        HashMultimap baseMap = HashMultimap.create();
        AsyncConsistentMultimapMock asyncMultiMap = new AsyncConsistentMultimapMock(baseMap);
        DefaultConsistentMultimap newMap = new DefaultConsistentMultimap(asyncMultiMap, 69L);
        MatcherAssert.assertThat((Object)newMap.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)newMap.isEmpty(), (Matcher)Matchers.is((Object)true));
        HashMap mapping = Maps.newHashMap();
        this.allKeys.forEach(key -> {
            switch (key) {
                case "AAA": {
                    mapping.put(key, Lists.newArrayList(this.allValues.subList(0, 1)));
                    break;
                }
                case "BBB": {
                    mapping.put(key, Lists.newArrayList(this.allValues.subList(0, 2)));
                    break;
                }
                case "CCC": {
                    mapping.put(key, Lists.newArrayList(this.allValues.subList(0, 3)));
                    break;
                }
                default: {
                    mapping.put(key, Lists.newArrayList(this.allValues.subList(0, 4)));
                }
            }
        });
        MatcherAssert.assertThat((Object)newMap.putAll((Map)mapping), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newMap.putAll((Map)mapping), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)newMap.size(), (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)newMap.isEmpty(), (Matcher)Matchers.is((Object)false));
        this.allKeys.forEach(arg_0 -> this.lambda$testBehavior$1((ConsistentMultimap)newMap, arg_0));
        MatcherAssert.assertThat((Object)newMap.removeAll((Map)mapping), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newMap.removeAll((Map)mapping), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)newMap.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)newMap.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    private /* synthetic */ void lambda$testBehavior$1(ConsistentMultimap newMap, String key) {
        switch (key) {
            case "AAA": {
                MatcherAssert.assertThat((Object)Lists.newArrayList((Iterable)((Iterable)Versioned.valueOrNull((Versioned)newMap.get((Object)key)))), (Matcher)Matchers.containsInAnyOrder((Object[])this.allValues.subList(0, 1).toArray()));
                break;
            }
            case "BBB": {
                MatcherAssert.assertThat((Object)Lists.newArrayList((Iterable)((Iterable)Versioned.valueOrNull((Versioned)newMap.get((Object)key)))), (Matcher)Matchers.containsInAnyOrder((Object[])this.allValues.subList(0, 2).toArray()));
                break;
            }
            case "CCC": {
                MatcherAssert.assertThat((Object)Lists.newArrayList((Iterable)((Iterable)Versioned.valueOrNull((Versioned)newMap.get((Object)key)))), (Matcher)Matchers.containsInAnyOrder((Object[])this.allValues.subList(0, 3).toArray()));
                break;
            }
            default: {
                MatcherAssert.assertThat((Object)Lists.newArrayList((Iterable)((Iterable)Versioned.valueOrNull((Versioned)newMap.get((Object)key)))), (Matcher)Matchers.containsInAnyOrder((Object[])this.allValues.subList(0, 4).toArray()));
            }
        }
    }

    public static class AsyncConsistentMultimapMock<K, V>
    extends AsyncConsistentMultimapAdapter<K, V> {
        private final Multimap<K, V> baseMap;
        private static final int DEFAULT_CREATION_TIME = 0;
        private static final int DEFAULT_VERSION = 0;

        AsyncConsistentMultimapMock(Multimap<K, V> newBaseMap) {
            this.baseMap = newBaseMap;
        }

        Versioned<Collection<? extends V>> makeVersioned(Collection<? extends V> v) {
            return new Versioned(v, 0L, 0L);
        }

        @Override
        public CompletableFuture<Integer> size() {
            return CompletableFuture.completedFuture(this.baseMap.size());
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return CompletableFuture.completedFuture(this.baseMap.isEmpty());
        }

        @Override
        public CompletableFuture<Boolean> putAll(Map<K, Collection<? extends V>> mapping) {
            CompletableFuture<Boolean> result = CompletableFuture.completedFuture(false);
            for (Map.Entry<K, Collection<V>> entry : mapping.entrySet()) {
                if (!this.baseMap.putAll(entry.getKey(), (Iterable)entry.getValue())) continue;
                result = CompletableFuture.completedFuture(true);
            }
            return result;
        }

        @Override
        public CompletableFuture<Versioned<Collection<? extends V>>> get(K key) {
            return CompletableFuture.completedFuture(this.makeVersioned(this.baseMap.get(key)));
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Map<K, Collection<? extends V>> mapping) {
            CompletableFuture<Boolean> result = CompletableFuture.completedFuture(false);
            for (Map.Entry<K, Collection<V>> entry : mapping.entrySet()) {
                for (V value : entry.getValue()) {
                    if (!this.baseMap.remove(entry.getKey(), value)) continue;
                    result = CompletableFuture.completedFuture(true);
                }
            }
            return result;
        }
    }
}

