/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.provider.ProviderId;

public class DefaultDeviceTest {
    static final ProviderId PID = new ProviderId("of", "foo");
    static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    static final DeviceId DID2 = DeviceId.deviceId((String)"of:bar");
    static final String MFR = "whitebox";
    static final String HW = "1.1.x";
    static final String SW = "3.9.1";
    static final String SN1 = "43311-12345";
    static final String SN2 = "42346-43512";
    static final ChassisId CID = new ChassisId();

    @Test
    public void testEquality() {
        DefaultDevice d1 = new DefaultDevice(PID, DID1, Device.Type.SWITCH, MFR, HW, SW, SN1, CID, new Annotations[0]);
        DefaultDevice d2 = new DefaultDevice(PID, DID1, Device.Type.SWITCH, MFR, HW, SW, SN1, CID, new Annotations[0]);
        DefaultDevice d3 = new DefaultDevice(PID, DID2, Device.Type.SWITCH, MFR, HW, SW, SN2, CID, new Annotations[0]);
        DefaultDevice d4 = new DefaultDevice(PID, DID2, Device.Type.SWITCH, MFR, HW, SW, SN2, CID, new Annotations[0]);
        DefaultDevice d5 = new DefaultDevice(PID, DID2, Device.Type.SWITCH, MFR, HW, SW, SN1, CID, new Annotations[0]);
        new EqualsTester().addEqualityGroup(new Object[]{d1, d2}).addEqualityGroup(new Object[]{d3, d4}).addEqualityGroup(new Object[]{d5}).testEquals();
    }

    @Test
    public void basics() {
        DefaultDevice device = new DefaultDevice(PID, DID1, Device.Type.SWITCH, MFR, HW, SW, SN1, CID, new Annotations[0]);
        this.validate((Device)device);
    }

    @Test
    public void annotations() {
        DefaultDevice device = new DefaultDevice(PID, DID1, Device.Type.SWITCH, MFR, HW, SW, SN1, CID, new Annotations[]{DefaultAnnotations.builder().set("foo", "bar").build()});
        this.validate((Device)device);
        Assert.assertEquals((String)"incorrect provider", (Object)"bar", (Object)device.annotations().value("foo"));
    }

    private void validate(Device device) {
        Assert.assertEquals((String)"incorrect provider", (Object)PID, (Object)device.providerId());
        Assert.assertEquals((String)"incorrect id", (Object)DID1, (Object)device.id());
        Assert.assertEquals((String)"incorrect type", (Object)Device.Type.SWITCH, (Object)device.type());
        Assert.assertEquals((String)"incorrect manufacturer", (Object)MFR, (Object)device.manufacturer());
        Assert.assertEquals((String)"incorrect hw", (Object)HW, (Object)device.hwVersion());
        Assert.assertEquals((String)"incorrect sw", (Object)SW, (Object)device.swVersion());
        Assert.assertEquals((String)"incorrect serial", (Object)SN1, (Object)device.serialNumber());
    }
}

