/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.MacAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.behaviour.TunnelEndPoint;

public class TunnelEndPointTest {
    private ConnectPoint cp1 = NetTestTools.connectPoint("cp1", 1);
    private TunnelEndPoint<ConnectPoint> endPoint1 = new TunnelEndPoint((Object)this.cp1);
    private TunnelEndPoint<ConnectPoint> sameAsEndPoint1 = new TunnelEndPoint((Object)this.cp1);
    private ConnectPoint cp2 = NetTestTools.connectPoint("cp2", 2);
    private TunnelEndPoint<ConnectPoint> endPoint2 = new TunnelEndPoint((Object)this.cp2);
    private TunnelEndPoint<MacAddress> endPoint3 = new TunnelEndPoint((Object)MacAddress.BROADCAST);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(TunnelEndPoint.class);
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.endPoint1.value(), (Matcher)Matchers.is((Object)this.cp1));
        MatcherAssert.assertThat((Object)this.endPoint1.strValue(), (Matcher)Matchers.is((Object)this.cp1.toString()));
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.endPoint1, this.sameAsEndPoint1}).addEqualityGroup(new Object[]{this.endPoint2}).addEqualityGroup(new Object[]{this.endPoint3}).testEquals();
    }
}

