/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.testing.EqualsTester;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.DefaultObjectiveContext;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;

public class ObjectiveTest {
    private final TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
    private final TrafficSelector selector = DefaultTrafficSelector.emptySelector();
    private final Criterion criterion = Criteria.dummy();
    private final Criterion key = Criteria.dummy();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultFilteringObjective.class);
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultForwardingObjective.class);
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultNextObjective.class);
    }

    private ForwardingObjective.Builder baseForwardingBuilder() {
        return DefaultForwardingObjective.builder().withSelector(this.selector).withTreatment(this.treatment).withFlag(ForwardingObjective.Flag.SPECIFIC).withMeta(this.selector).fromApp(NetTestTools.APP_ID).withPriority(22).makeTemporary(5).nextStep(33);
    }

    private void checkForwardingBase(ForwardingObjective objective, Objective.Operation op, ObjectiveContext expectedContext) {
        MatcherAssert.assertThat((Object)objective.permanent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)objective.timeout(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)objective.selector(), (Matcher)CoreMatchers.is((Object)this.selector));
        MatcherAssert.assertThat((Object)objective.meta(), (Matcher)CoreMatchers.is((Object)this.selector));
        MatcherAssert.assertThat((Object)objective.treatment(), (Matcher)CoreMatchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)objective.flag(), (Matcher)CoreMatchers.is((Object)ForwardingObjective.Flag.SPECIFIC));
        MatcherAssert.assertThat((Object)objective.appId(), (Matcher)CoreMatchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)objective.nextId(), (Matcher)CoreMatchers.is((Object)33));
        MatcherAssert.assertThat((Object)objective.id(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Object)0)));
        MatcherAssert.assertThat((Object)objective.priority(), (Matcher)CoreMatchers.is((Object)22));
        MatcherAssert.assertThat((Object)objective.op(), (Matcher)CoreMatchers.is((Object)op));
        if (objective.context().isPresent()) {
            MatcherAssert.assertThat(objective.context().get(), (Matcher)CoreMatchers.is((Object)expectedContext));
        } else {
            MatcherAssert.assertThat((Object)expectedContext, (Matcher)CoreMatchers.nullValue());
        }
    }

    @Test
    public void testForwardingAdd() {
        this.checkForwardingBase(this.baseForwardingBuilder().add(), Objective.Operation.ADD, null);
    }

    @Test
    public void testForwardingAddWithContext() {
        DefaultObjectiveContext context = new DefaultObjectiveContext(null, null);
        this.checkForwardingBase(this.baseForwardingBuilder().add((ObjectiveContext)context), Objective.Operation.ADD, (ObjectiveContext)context);
    }

    @Test
    public void testForwardingRemove() {
        this.checkForwardingBase(this.baseForwardingBuilder().remove(), Objective.Operation.REMOVE, null);
    }

    @Test
    public void testForwardingRemoveWithContext() {
        DefaultObjectiveContext context = new DefaultObjectiveContext(null, null);
        this.checkForwardingBase(this.baseForwardingBuilder().remove((ObjectiveContext)context), Objective.Operation.REMOVE, (ObjectiveContext)context);
    }

    private FilteringObjective.Builder baseFilteringBuilder() {
        return DefaultFilteringObjective.builder().withKey(this.key).withPriority(5).withMeta(this.treatment).addCondition(this.criterion).fromApp(NetTestTools.APP_ID).makeTemporary(2).deny();
    }

    private void checkFilteringBase(FilteringObjective objective, Objective.Operation op, ObjectiveContext expectedContext) {
        MatcherAssert.assertThat((Object)objective.key(), (Matcher)CoreMatchers.is((Object)this.key));
        MatcherAssert.assertThat((Object)objective.conditions(), (Matcher)CoreMatchers.hasItem((Object)this.criterion));
        MatcherAssert.assertThat((Object)objective.meta(), (Matcher)CoreMatchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)objective.permanent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)objective.timeout(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)objective.priority(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)objective.appId(), (Matcher)CoreMatchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)objective.type(), (Matcher)CoreMatchers.is((Object)FilteringObjective.Type.DENY));
        MatcherAssert.assertThat((Object)objective.id(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Object)0)));
        MatcherAssert.assertThat((Object)objective.op(), (Matcher)CoreMatchers.is((Object)op));
        if (objective.context().isPresent()) {
            MatcherAssert.assertThat(objective.context().get(), (Matcher)CoreMatchers.is((Object)expectedContext));
        } else {
            MatcherAssert.assertThat((Object)expectedContext, (Matcher)CoreMatchers.nullValue());
        }
    }

    @Test
    public void testFilteringAdd() {
        this.checkFilteringBase(this.baseFilteringBuilder().add(), Objective.Operation.ADD, null);
    }

    @Test
    public void testFilteringAddWithContext() {
        DefaultObjectiveContext context = new DefaultObjectiveContext(null, null);
        this.checkFilteringBase(this.baseFilteringBuilder().add((ObjectiveContext)context), Objective.Operation.ADD, (ObjectiveContext)context);
    }

    @Test
    public void testFilteringRemove() {
        this.checkFilteringBase(this.baseFilteringBuilder().remove(), Objective.Operation.REMOVE, null);
    }

    @Test
    public void testFilteringRemoveWithContext() {
        DefaultObjectiveContext context = new DefaultObjectiveContext(null, null);
        this.checkFilteringBase(this.baseFilteringBuilder().remove((ObjectiveContext)context), Objective.Operation.REMOVE, (ObjectiveContext)context);
    }

    private NextObjective.Builder baseNextBuilder() {
        return DefaultNextObjective.builder().addTreatment(this.treatment).withId(12).withType(NextObjective.Type.HASHED).withMeta(this.selector).makeTemporary(777).withPriority(33).fromApp(NetTestTools.APP_ID);
    }

    private void checkNextBase(NextObjective objective, Objective.Operation op, ObjectiveContext expectedContext) {
        MatcherAssert.assertThat((Object)objective.id(), (Matcher)CoreMatchers.is((Object)12));
        MatcherAssert.assertThat((Object)objective.appId(), (Matcher)CoreMatchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)objective.type(), (Matcher)CoreMatchers.is((Object)NextObjective.Type.HASHED));
        MatcherAssert.assertThat((Object)objective.next(), (Matcher)CoreMatchers.hasItem((Object)this.treatment));
        MatcherAssert.assertThat((Object)objective.meta(), (Matcher)CoreMatchers.is((Object)this.selector));
        MatcherAssert.assertThat((Object)objective.permanent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)objective.timeout(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)objective.priority(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)objective.op(), (Matcher)CoreMatchers.is((Object)op));
        if (objective.context().isPresent()) {
            MatcherAssert.assertThat(objective.context().get(), (Matcher)CoreMatchers.is((Object)expectedContext));
        } else {
            MatcherAssert.assertThat((Object)expectedContext, (Matcher)CoreMatchers.nullValue());
        }
    }

    @Test
    public void testNextAdd() {
        this.checkNextBase(this.baseNextBuilder().add(), Objective.Operation.ADD, null);
    }

    @Test
    public void testNextAddWithContext() {
        DefaultObjectiveContext context = new DefaultObjectiveContext(null, null);
        this.checkNextBase(this.baseNextBuilder().add((ObjectiveContext)context), Objective.Operation.ADD, (ObjectiveContext)context);
    }

    @Test
    public void testNextRemove() {
        this.checkNextBase(this.baseNextBuilder().remove(), Objective.Operation.REMOVE, null);
    }

    @Test
    public void testNextRemoveWithContext() {
        DefaultObjectiveContext context = new DefaultObjectiveContext(null, null);
        this.checkNextBase(this.baseNextBuilder().remove((ObjectiveContext)context), Objective.Operation.REMOVE, (ObjectiveContext)context);
    }

    @Test
    public void testEqualsNextObjective() {
        NextObjective next1 = this.baseNextBuilder().add();
        NextObjective sameAsNext1 = next1.copy().add();
        NextObjective next2 = this.baseNextBuilder().verify();
        NextObjective next3 = this.baseNextBuilder().fromApp((ApplicationId)new TestApplicationId("foo2")).verify();
        NextObjective next4 = this.baseNextBuilder().withType(NextObjective.Type.FAILOVER).verify();
        NextObjective next5 = this.baseNextBuilder().addTreatment(DefaultTrafficTreatment.emptyTreatment()).verify();
        new EqualsTester().addEqualityGroup(new Object[]{next1, sameAsNext1}).addEqualityGroup(new Object[]{next2}).addEqualityGroup(new Object[]{next3}).addEqualityGroup(new Object[]{next4}).addEqualityGroup(new Object[]{next5}).testEquals();
    }

    @Test
    public void testToFromExistingNextObjective() {
        NextObjective next1 = this.baseNextBuilder().addToExisting();
        this.checkNextBase(next1, Objective.Operation.ADD_TO_EXISTING, null);
    }

    @Test
    public void testRemoveFromExistingNextObjective() {
        NextObjective next1 = this.baseNextBuilder().removeFromExisting();
        this.checkNextBase(next1, Objective.Operation.REMOVE_FROM_EXISTING, null);
    }

    @Test
    public void testEqualsFilteringObjective() {
        FilteringObjective filter1 = this.baseFilteringBuilder().add();
        FilteringObjective sameAsFilter1 = filter1.copy().add();
        FilteringObjective filter2 = this.baseFilteringBuilder().permit().add();
        FilteringObjective filter3 = this.baseFilteringBuilder().fromApp((ApplicationId)new TestApplicationId("foo2")).add();
        FilteringObjective filter4 = this.baseFilteringBuilder().permit().remove();
        FilteringObjective filter5 = this.baseFilteringBuilder().withPriority(55).add();
        FilteringObjective filter6 = this.baseFilteringBuilder().makePermanent().add();
        new EqualsTester().addEqualityGroup(new Object[]{filter1, sameAsFilter1}).addEqualityGroup(new Object[]{filter2}).addEqualityGroup(new Object[]{filter3}).addEqualityGroup(new Object[]{filter4}).addEqualityGroup(new Object[]{filter5}).addEqualityGroup(new Object[]{filter6}).testEquals();
    }

    @Test
    public void testToFromExistingFilteringObjective() {
        FilteringObjective filter1 = this.baseFilteringBuilder().add(null);
        this.checkFilteringBase(filter1, Objective.Operation.ADD, null);
    }

    @Test
    public void testRemoveFromExistingFilteringObjective() {
        FilteringObjective filter1 = this.baseFilteringBuilder().remove(null);
        this.checkFilteringBase(filter1, Objective.Operation.REMOVE, null);
    }

    @Test
    public void testEqualsForwardingObjective() {
        ForwardingObjective forward1 = this.baseForwardingBuilder().add();
        ForwardingObjective sameAsForward1 = forward1.copy().add();
        ForwardingObjective forward2 = this.baseForwardingBuilder().withFlag(ForwardingObjective.Flag.VERSATILE).add();
        ForwardingObjective forward3 = this.baseForwardingBuilder().fromApp((ApplicationId)new TestApplicationId("foo2")).add();
        ForwardingObjective forward4 = this.baseForwardingBuilder().remove();
        ForwardingObjective forward5 = this.baseForwardingBuilder().withPriority(55).add();
        ForwardingObjective forward6 = this.baseForwardingBuilder().makePermanent().add();
        new EqualsTester().addEqualityGroup(new Object[]{forward1, sameAsForward1}).addEqualityGroup(new Object[]{forward2}).addEqualityGroup(new Object[]{forward3}).addEqualityGroup(new Object[]{forward4}).addEqualityGroup(new Object[]{forward5}).addEqualityGroup(new Object[]{forward6}).testEquals();
    }

    @Test
    public void testToFromExistingForwardingObjective() {
        ForwardingObjective forward1 = this.baseForwardingBuilder().add(null);
        this.checkForwardingBase(forward1, Objective.Operation.ADD, null);
    }

    @Test
    public void testRemoveFromExistingForwardingObjective() {
        ForwardingObjective forward1 = this.baseForwardingBuilder().remove(null);
        this.checkForwardingBase(forward1, Objective.Operation.REMOVE, null);
    }

    @Test
    public void testDefaultContext() {
        FilteringObjective objective = this.baseFilteringBuilder().add();
        ObjectiveContextAdapter context = new ObjectiveContextAdapter(ContextType.BOTH);
        context.onSuccess((Objective)objective);
        MatcherAssert.assertThat((Object)context.successCount(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)context.errorCount(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)context.objectiveError(), (Matcher)CoreMatchers.is((Object)ObjectiveError.UNKNOWN));
        MatcherAssert.assertThat((Object)context.objectiveInError(), (Matcher)CoreMatchers.nullValue());
        context = new ObjectiveContextAdapter(ContextType.BOTH);
        context.onError((Objective)objective, ObjectiveError.UNSUPPORTED);
        MatcherAssert.assertThat((Object)context.successCount(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)context.errorCount(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)context.objectiveError(), (Matcher)CoreMatchers.is((Object)ObjectiveError.UNSUPPORTED));
        MatcherAssert.assertThat((Object)context.objectiveInError(), (Matcher)CoreMatchers.equalTo((Object)objective));
        context = new ObjectiveContextAdapter(ContextType.SUCCESS_ONLY);
        context.onSuccess((Objective)objective);
        MatcherAssert.assertThat((Object)context.successCount(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)context.errorCount(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)context.objectiveError(), (Matcher)CoreMatchers.is((Object)ObjectiveError.UNKNOWN));
        MatcherAssert.assertThat((Object)context.objectiveInError(), (Matcher)CoreMatchers.nullValue());
        context = new ObjectiveContextAdapter(ContextType.ERROR_ONLY);
        context.onError((Objective)objective, ObjectiveError.UNSUPPORTED);
        MatcherAssert.assertThat((Object)context.successCount(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)context.errorCount(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)context.objectiveError(), (Matcher)CoreMatchers.is((Object)ObjectiveError.UNSUPPORTED));
        MatcherAssert.assertThat((Object)context.objectiveInError(), (Matcher)CoreMatchers.equalTo((Object)objective));
    }

    class ObjectiveContextAdapter
    implements ObjectiveContext {
        DefaultObjectiveContext context;
        int successCount = 0;
        int errorCount = 0;
        ObjectiveError objectiveError = ObjectiveError.UNKNOWN;
        Objective objectiveInError = null;

        ObjectiveContextAdapter(ContextType type) {
            switch (type) {
                case ERROR_ONLY: {
                    this.context = new DefaultObjectiveContext((failedObjective, error) -> {
                        ++this.errorCount;
                        this.objectiveInError = failedObjective;
                        this.objectiveError = error;
                    });
                    break;
                }
                case SUCCESS_ONLY: {
                    this.context = new DefaultObjectiveContext(successfulObjective -> ++this.successCount);
                    break;
                }
                default: {
                    this.context = new DefaultObjectiveContext(successfulObjective -> ++this.successCount, (failedObjective, error) -> {
                        ++this.errorCount;
                        this.objectiveInError = failedObjective;
                        this.objectiveError = error;
                    });
                }
            }
        }

        public void onSuccess(Objective objective) {
            this.context.onSuccess(objective);
        }

        public void onError(Objective objective, ObjectiveError error) {
            this.context.onError(objective, error);
        }

        int successCount() {
            return this.successCount;
        }

        int errorCount() {
            return this.errorCount;
        }

        ObjectiveError objectiveError() {
            return this.objectiveError;
        }

        Objective objectiveInError() {
            return this.objectiveInError;
        }
    }

    static enum ContextType {
        BOTH,
        ERROR_ONLY,
        SUCCESS_ONLY;

    }
}

