/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Objects;
import org.onlab.packet.DscpClass;
import org.onlab.util.Bandwidth;
import org.onosproject.net.behaviour.BandwidthProfileAction;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.Meter;

@Beta
public final class BandwidthProfile {
    private final String name;
    private final Bandwidth cir;
    private final Bandwidth pir;
    private final Integer cbs;
    private final Integer pbs;
    private final Integer ebs;
    private final BandwidthProfileAction greenAction;
    private final BandwidthProfileAction yellowAction;
    private final BandwidthProfileAction redAction;
    private final boolean colorAware;

    private BandwidthProfile(String name, Bandwidth cir, Bandwidth pir, Integer cbs, Integer pbs, Integer ebs, BandwidthProfileAction greenAction, BandwidthProfileAction yellowAction, BandwidthProfileAction redAction, boolean colorAware) {
        this.name = name;
        this.cir = cir;
        this.pir = pir;
        this.cbs = cbs;
        this.pbs = pbs;
        this.ebs = ebs;
        this.greenAction = greenAction;
        this.yellowAction = yellowAction;
        this.redAction = redAction;
        this.colorAware = colorAware;
    }

    public String name() {
        return this.name;
    }

    public Bandwidth cir() {
        return this.cir;
    }

    public Bandwidth pir() {
        return this.pir;
    }

    public Integer cbs() {
        return this.cbs;
    }

    public Integer pbs() {
        return this.pbs;
    }

    public Integer ebs() {
        return this.ebs;
    }

    public BandwidthProfileAction greenAction() {
        return this.greenAction;
    }

    public BandwidthProfileAction yellowAction() {
        return this.yellowAction;
    }

    public BandwidthProfileAction redAction() {
        return this.redAction;
    }

    public boolean colorAware() {
        return this.colorAware;
    }

    public Type type() {
        return this.pir != null ? Type.trTCM : (this.ebs != null ? Type.srTCM : Type.sr2CM);
    }

    public static BandwidthProfile fromMeter(Meter meter) {
        Band yellowBand;
        Band bandTwo;
        Preconditions.checkNotNull((Object)meter);
        Preconditions.checkArgument((meter.bands().size() <= 2 ? 1 : 0) != 0, (Object)"Meter must have no more than two bands.");
        Iterator<Band> bandIterator = meter.bands().iterator();
        Band bandOne = bandIterator.next();
        Band band = bandTwo = bandIterator.hasNext() ? bandIterator.next() : null;
        Band band2 = bandTwo == null ? null : (yellowBand = bandTwo.rate() > bandOne.rate() ? bandOne : bandTwo);
        Band redBand = bandTwo == null ? bandOne : (yellowBand == bandOne ? bandTwo : bandOne);
        Builder bandwidthProfileBuilder = new Builder().name(meter.id().toString()).colorAware(false).greenAction(BandwidthProfile.getBuilder(BandwidthProfileAction.Action.PASS).build());
        if (yellowBand != null) {
            BandwidthProfileAction yellowAction = BandwidthProfile.getBwProfileActionFromBand(yellowBand);
            Preconditions.checkNotNull((Object)yellowAction, (Object)"Could not obtain yellow action from meter band");
            bandwidthProfileBuilder.cir(Bandwidth.kBps((long)yellowBand.rate())).cbs(yellowBand.burst() == null ? null : Integer.valueOf(yellowBand.burst().intValue())).pir(Bandwidth.kBps((long)redBand.rate())).pbs(redBand.burst() == null ? null : Integer.valueOf(redBand.burst().intValue())).yellowAction(yellowAction);
        } else {
            bandwidthProfileBuilder.cir(Bandwidth.kBps((long)redBand.rate())).cbs(redBand.burst() == null ? null : Integer.valueOf(redBand.burst().intValue()));
        }
        BandwidthProfileAction redAction = BandwidthProfile.getBwProfileActionFromBand(redBand);
        Preconditions.checkNotNull((Object)redAction, (Object)"Could not obtain red action from meter band");
        return bandwidthProfileBuilder.redAction(redAction).build();
    }

    private static BandwidthProfileAction.Builder getBuilder(BandwidthProfileAction.Action action) {
        return BandwidthProfileAction.builder().action(action);
    }

    private static BandwidthProfileAction getBwProfileActionFromBand(Band band) {
        Preconditions.checkNotNull((Object)((Object)band.type()), (Object)"Could not obtain BW profile: Meter band type is null");
        BandwidthProfileAction.Action action = null;
        if (band.type().equals((Object)Band.Type.DROP)) {
            action = BandwidthProfileAction.Action.DISCARD;
        } else if (band.type().equals((Object)Band.Type.REMARK)) {
            action = BandwidthProfileAction.Action.REMARK;
        }
        Preconditions.checkNotNull((Object)((Object)action), (Object)"Could not obtain BW profile: Invalid meter band type");
        BandwidthProfileAction.Builder actionBuilder = BandwidthProfile.getBuilder(action);
        if (band.type().equals((Object)Band.Type.REMARK)) {
            Preconditions.checkNotNull((Object)band.dropPrecedence(), (Object)"Could not obtain DSCP class from meter band");
            actionBuilder.dscpClass(DscpClass.fromShort((short)band.dropPrecedence()));
        }
        return actionBuilder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.cir, this.pir, this.cbs, this.pbs, this.ebs, this.greenAction, this.yellowAction, this.redAction, this.colorAware);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BandwidthProfile) {
            BandwidthProfile that = (BandwidthProfile)obj;
            return this.getClass() == that.getClass() && Objects.equals(this.cir, that.cir) && Objects.equals(this.pir, that.pir) && Objects.equals(this.cbs, that.cbs) && Objects.equals(this.pbs, that.pbs) && Objects.equals(this.ebs, that.ebs) && Objects.equals(this.greenAction, that.greenAction) && Objects.equals(this.yellowAction, that.yellowAction) && Objects.equals(this.redAction, that.redAction) && Objects.equals(this.colorAware, that.colorAware);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("cir", (Object)this.cir).add("pir", (Object)this.pir).add("cbs", (Object)this.cbs).add("pbs", (Object)this.pbs).add("ebs", (Object)this.ebs).add("greenAction", (Object)this.greenAction).add("yellowAction", (Object)this.yellowAction).add("redAction", (Object)this.redAction).add("colorAware", this.colorAware).toString();
    }

    public static final class Builder {
        private String name;
        private Bandwidth cir;
        private Bandwidth pir;
        private Integer cbs;
        private Integer pbs;
        private Integer ebs;
        private BandwidthProfileAction greenAction;
        private BandwidthProfileAction yellowAction;
        private BandwidthProfileAction redAction;
        private boolean colorAware;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder cir(Bandwidth cir) {
            this.cir = cir;
            return this;
        }

        public Builder pir(Bandwidth pir) {
            this.pir = pir;
            return this;
        }

        public Builder cbs(Integer cbs) {
            this.cbs = cbs;
            return this;
        }

        public Builder pbs(Integer pbs) {
            this.pbs = pbs;
            return this;
        }

        public Builder ebs(Integer ebs) {
            this.ebs = ebs;
            return this;
        }

        public Builder greenAction(BandwidthProfileAction greenAction) {
            this.greenAction = greenAction;
            return this;
        }

        public Builder yellowAction(BandwidthProfileAction yellowAction) {
            this.yellowAction = yellowAction;
            return this;
        }

        public Builder redAction(BandwidthProfileAction redAction) {
            this.redAction = redAction;
            return this;
        }

        public Builder colorAware(boolean colorAware) {
            this.colorAware = colorAware;
            return this;
        }

        public BandwidthProfile build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"Bandwidth profile must have a name");
            Preconditions.checkNotNull((Object)this.cir, (Object)"Bandwidth profile must have a CIR");
            Preconditions.checkNotNull((Object)this.greenAction, (Object)"Bandwidth profile must have a green action");
            Preconditions.checkNotNull((Object)this.redAction, (Object)"Bandwidth profile must have a red action");
            Preconditions.checkArgument((this.pir != null || this.pbs == null ? 1 : 0) != 0, (Object)"Bandwidth profile cannot have PBS without PIR");
            Preconditions.checkArgument((this.pir == null || this.ebs == null ? 1 : 0) != 0, (Object)"Bandwidth profile cannot have both PIR and EBS");
            Preconditions.checkArgument((this.yellowAction == null && this.pir == null && this.ebs == null || this.yellowAction != null && this.pir != null ^ this.ebs != null ? 1 : 0) != 0, (Object)"Bandwidth profile must have a yellow action only when either PIR or EBS are defined");
            return new BandwidthProfile(this.name, this.cir, this.pir, this.cbs, this.pbs, this.ebs, this.greenAction, this.yellowAction, this.redAction, this.colorAware);
        }
    }

    static enum Type {
        sr2CM,
        srTCM,
        trTCM;

    }
}

