/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.behaviour.trafficcontrol.PolicerId;

@Beta
public final class PolicingResource
implements NetworkResource {
    private final PolicerId policerId;
    private final ConnectPoint connectPoint;

    public PolicingResource(PolicerId pId, ConnectPoint cP) {
        Preconditions.checkNotNull((Object)((Object)pId), (Object)"Must specify a policer id");
        Preconditions.checkNotNull((Object)cP, (Object)"Must specify a connect point");
        this.policerId = pId;
        this.connectPoint = cP;
    }

    public PolicerId policerId() {
        return this.policerId;
    }

    public ConnectPoint connectPoint() {
        return this.connectPoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.policerId()).add("connectPoint", (Object)this.connectPoint()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicingResource that = (PolicingResource)o;
        return Objects.equal((Object)((Object)this.policerId), (Object)((Object)that.policerId)) && Objects.equal((Object)this.connectPoint, (Object)that.connectPoint);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.policerId, this.connectPoint});
    }
}

