/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onlab.util.Identifier;
import org.onosproject.net.resource.ResourceConsumer;

public class ResourceConsumerId {
    private final String className;
    private final long value;

    protected ResourceConsumerId() {
        this.className = null;
        this.value = 0L;
    }

    ResourceConsumerId(long value, Class<?> cls) {
        this.className = (String)Preconditions.checkNotNull((Object)cls.getName());
        this.value = value;
    }

    public boolean isClassOf(Class<?> cls) {
        return ((Class)Preconditions.checkNotNull(cls)).getName().equals(this.className);
    }

    public String consumerClass() {
        return this.className;
    }

    public long value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceConsumerId that = (ResourceConsumerId)o;
        return Objects.equal((Object)this.className, (Object)that.className) && Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.className, this.value});
    }

    public static <T extends ResourceConsumer> ResourceConsumerId of(long value, Class<T> cls) {
        return new ResourceConsumerId(value, cls);
    }

    public static <T extends Identifier<Long>> ResourceConsumerId of(T id) {
        return new ResourceConsumerId((Long)id.id(), id.getClass());
    }
}

