/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.DefaultLinkTest;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;

public class DefaultEdgeLinkTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    private static final HostId HID1 = HostId.hostId((String)"00:00:00:00:00:01/-1");
    private static final HostId HID2 = HostId.hostId((String)"00:00:00:00:00:01/-1");
    private static final PortNumber P0 = PortNumber.portNumber((long)0L);
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);

    @Test
    public void testEquality() {
        DefaultEdgeLink l1 = new DefaultEdgeLink(PID, DefaultLinkTest.cp((ElementId)HID1, P0), new HostLocation(DID1, P1, 123L), true, new Annotations[0]);
        DefaultEdgeLink l2 = new DefaultEdgeLink(PID, DefaultLinkTest.cp((ElementId)HID1, P0), new HostLocation(DID1, P1, 123L), true, new Annotations[0]);
        DefaultEdgeLink l3 = new DefaultEdgeLink(PID, DefaultLinkTest.cp((ElementId)HID2, P0), new HostLocation(DID1, P1, 123L), false, new Annotations[0]);
        DefaultEdgeLink l4 = new DefaultEdgeLink(PID, DefaultLinkTest.cp((ElementId)HID2, P0), new HostLocation(DID1, P1, 123L), false, new Annotations[0]);
        new EqualsTester().addEqualityGroup(new Object[]{l1, l2}).addEqualityGroup(new Object[]{l3, l4}).testEquals();
    }

    @Test
    public void basics() {
        HostLocation hostLocation = new HostLocation(DID1, P1, 123L);
        DefaultEdgeLink link = new DefaultEdgeLink(PID, DefaultLinkTest.cp((ElementId)HID1, P0), hostLocation, false, new Annotations[0]);
        Assert.assertEquals((String)"incorrect src", (Object)DefaultLinkTest.cp((ElementId)HID1, P0), (Object)link.dst());
        Assert.assertEquals((String)"incorrect dst", (Object)hostLocation, (Object)link.src());
        Assert.assertEquals((String)"incorrect type", (Object)Link.Type.EDGE, (Object)link.type());
        Assert.assertEquals((String)"incorrect hostId", (Object)HID1, (Object)link.hostId());
        Assert.assertEquals((String)"incorrect connect point", (Object)hostLocation, (Object)link.hostLocation());
        Assert.assertEquals((String)"incorrect time", (long)123L, (long)link.hostLocation().time());
    }

    @Test
    public void phantomIngress() {
        HostLocation hostLocation = new HostLocation(DID1, P1, 123L);
        DefaultEdgeLink link = DefaultEdgeLink.createEdgeLink((ConnectPoint)hostLocation, (boolean)true);
        Assert.assertEquals((String)"incorrect dst", (Object)hostLocation, (Object)link.dst());
        Assert.assertEquals((String)"incorrect type", (Object)Link.Type.EDGE, (Object)link.type());
        Assert.assertEquals((String)"incorrect connect point", (Object)hostLocation, (Object)link.hostLocation());
        Assert.assertEquals((String)"incorrect time", (long)123L, (long)link.hostLocation().time());
    }

    @Test
    public void phantomEgress() {
        ConnectPoint hostLocation = new ConnectPoint((ElementId)DID1, P1);
        DefaultEdgeLink link = DefaultEdgeLink.createEdgeLink((ConnectPoint)hostLocation, (boolean)false);
        Assert.assertEquals((String)"incorrect src", (Object)hostLocation, (Object)link.src());
        Assert.assertEquals((String)"incorrect type", (Object)Link.Type.EDGE, (Object)link.type());
        Assert.assertEquals((String)"incorrect connect point", (Object)hostLocation, (Object)link.hostLocation());
        Assert.assertEquals((String)"incorrect time", (long)0L, (long)link.hostLocation().time());
    }
}

