/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.DefaultOchSignalComparator;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;

public class OchSignalTest {
    @Test
    public void testEquality() {
        OchSignal och1 = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)1);
        OchSignal sameOch1 = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)1);
        OchSignal och2 = new OchSignal(GridType.CWDM, ChannelSpacing.CHL_100GHZ, 4, 8);
        OchSignal sameOch2 = new OchSignal(GridType.CWDM, ChannelSpacing.CHL_100GHZ, 4, 8);
        OchSignal och3 = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)3);
        OchSignal sameOch3 = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)3);
        OchSignal och4 = OchSignal.newFlexGridSlot((int)3);
        OchSignal sameOch4 = OchSignal.newFlexGridSlot((int)3);
        new EqualsTester().addEqualityGroup(new Object[]{och1, sameOch1}).addEqualityGroup(new Object[]{och2, sameOch2}).addEqualityGroup(new Object[]{och3, sameOch3}).addEqualityGroup(new Object[]{och4, sameOch4}).testEquals();
    }

    @Test
    public void testToFlexgrid50() {
        OchSignal input = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)0);
        TreeSet expected = DefaultOchSignalComparator.newOchSignalTreeSet();
        expected.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)-3), (Object)OchSignal.newFlexGridSlot((int)-1), (Object)OchSignal.newFlexGridSlot((int)1), (Object)OchSignal.newFlexGridSlot((int)3)));
        SortedSet flexGrid = OchSignal.toFlexGrid((OchSignal)input);
        Assert.assertEquals((Object)expected, (Object)flexGrid);
    }

    @Test
    public void testToFlexgrid50Plus1() {
        OchSignal input = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)1);
        TreeSet expected = DefaultOchSignalComparator.newOchSignalTreeSet();
        expected.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)5), (Object)OchSignal.newFlexGridSlot((int)7), (Object)OchSignal.newFlexGridSlot((int)9), (Object)OchSignal.newFlexGridSlot((int)11)));
        SortedSet flexGrid = OchSignal.toFlexGrid((OchSignal)input);
        Assert.assertEquals((Object)expected, (Object)flexGrid);
    }

    @Test
    public void testToFlexgrid50minus1() {
        OchSignal input = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)-1);
        TreeSet expected = DefaultOchSignalComparator.newOchSignalTreeSet();
        expected.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)-11), (Object)OchSignal.newFlexGridSlot((int)-9), (Object)OchSignal.newFlexGridSlot((int)-7), (Object)OchSignal.newFlexGridSlot((int)-5)));
        SortedSet flexGrid = OchSignal.toFlexGrid((OchSignal)input);
        Assert.assertEquals((Object)expected, (Object)flexGrid);
    }

    @Test
    public void testToFlexgrid25() {
        OchSignal input = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_25GHZ, (int)0);
        TreeSet expected = DefaultOchSignalComparator.newOchSignalTreeSet();
        expected.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)-1), (Object)OchSignal.newFlexGridSlot((int)1)));
        SortedSet flexGrid = OchSignal.toFlexGrid((OchSignal)input);
        Assert.assertEquals((Object)expected, (Object)flexGrid);
    }

    @Test
    public void testToFlexgrid25Plus2() {
        OchSignal input = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_25GHZ, (int)2);
        TreeSet expected = DefaultOchSignalComparator.newOchSignalTreeSet();
        expected.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)7), (Object)OchSignal.newFlexGridSlot((int)9)));
        SortedSet flexGrid = OchSignal.toFlexGrid((OchSignal)input);
        Assert.assertEquals((Object)expected, (Object)flexGrid);
    }

    @Test
    public void testToFlexgrid25minus2() {
        OchSignal input = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_25GHZ, (int)-2);
        TreeSet expected = DefaultOchSignalComparator.newOchSignalTreeSet();
        expected.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)-9), (Object)OchSignal.newFlexGridSlot((int)-7)));
        SortedSet flexGrid = OchSignal.toFlexGrid((OchSignal)input);
        Assert.assertEquals((Object)expected, (Object)flexGrid);
    }

    @Test
    public void testToFixedgrid50() {
        TreeSet input = DefaultOchSignalComparator.newOchSignalTreeSet();
        input.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)-3), (Object)OchSignal.newFlexGridSlot((int)-1), (Object)OchSignal.newFlexGridSlot((int)1), (Object)OchSignal.newFlexGridSlot((int)3)));
        OchSignal expected = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)0);
        Assert.assertEquals((Object)expected, (Object)OchSignal.toFixedGrid((List)Lists.newArrayList((Iterable)input), (ChannelSpacing)ChannelSpacing.CHL_50GHZ));
    }

    @Test
    public void testToFixedgrid50plus1() {
        TreeSet input = DefaultOchSignalComparator.newOchSignalTreeSet();
        input.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)5), (Object)OchSignal.newFlexGridSlot((int)7), (Object)OchSignal.newFlexGridSlot((int)9), (Object)OchSignal.newFlexGridSlot((int)11)));
        OchSignal expected = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)1);
        Assert.assertEquals((Object)expected, (Object)OchSignal.toFixedGrid((List)Lists.newArrayList((Iterable)input), (ChannelSpacing)ChannelSpacing.CHL_50GHZ));
    }

    @Test
    public void testToFixedgrid50minus1() {
        TreeSet input = DefaultOchSignalComparator.newOchSignalTreeSet();
        input.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)-11), (Object)OchSignal.newFlexGridSlot((int)-9), (Object)OchSignal.newFlexGridSlot((int)-7), (Object)OchSignal.newFlexGridSlot((int)-5)));
        OchSignal expected = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)-1);
        Assert.assertEquals((Object)expected, (Object)OchSignal.toFixedGrid((List)Lists.newArrayList((Iterable)input), (ChannelSpacing)ChannelSpacing.CHL_50GHZ));
    }

    @Test
    public void testToFixedgrid25() {
        TreeSet input = DefaultOchSignalComparator.newOchSignalTreeSet();
        input.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)-1), (Object)OchSignal.newFlexGridSlot((int)1)));
        OchSignal expected = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_25GHZ, (int)0);
        Assert.assertEquals((Object)expected, (Object)OchSignal.toFixedGrid((List)Lists.newArrayList((Iterable)input), (ChannelSpacing)ChannelSpacing.CHL_25GHZ));
    }

    @Test
    public void testToFixedgrid25plus2() {
        TreeSet input = DefaultOchSignalComparator.newOchSignalTreeSet();
        input.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)7), (Object)OchSignal.newFlexGridSlot((int)9)));
        OchSignal expected = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_25GHZ, (int)2);
        Assert.assertEquals((Object)expected, (Object)OchSignal.toFixedGrid((List)Lists.newArrayList((Iterable)input), (ChannelSpacing)ChannelSpacing.CHL_25GHZ));
    }

    @Test
    public void testToFixedgrid25minus2() {
        TreeSet input = DefaultOchSignalComparator.newOchSignalTreeSet();
        input.addAll(ImmutableList.of((Object)OchSignal.newFlexGridSlot((int)-9), (Object)OchSignal.newFlexGridSlot((int)-7)));
        OchSignal expected = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_25GHZ, (int)-2);
        Assert.assertEquals((Object)expected, (Object)OchSignal.toFixedGrid((List)Lists.newArrayList((Iterable)input), (ChannelSpacing)ChannelSpacing.CHL_25GHZ));
    }
}

