/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onlab.packet.IpAddress;
import org.onosproject.net.behaviour.ControllerInfo;

public class ControllerInfoTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void tcpSslFormat() {
        String target = "tcp:192.168.1.1:6653";
        ControllerInfo controllerInfo = new ControllerInfo(target);
        Assert.assertEquals((String)"wrong type", (Object)controllerInfo.type(), (Object)"tcp");
        Assert.assertEquals((String)"wrong ip", (Object)controllerInfo.ip(), (Object)IpAddress.valueOf((String)"192.168.1.1"));
        Assert.assertEquals((String)"wrong port", (long)controllerInfo.port(), (long)6653L);
    }

    @Test
    public void ptcpPsslFormat() {
        String target = "ptcp:6653:192.168.1.1";
        ControllerInfo controllerInfo = new ControllerInfo(target);
        Assert.assertEquals((String)"wrong type", (Object)controllerInfo.type(), (Object)"ptcp");
        Assert.assertEquals((String)"wrong ip", (Object)controllerInfo.ip(), (Object)IpAddress.valueOf((String)"192.168.1.1"));
        Assert.assertEquals((String)"wrong port", (long)controllerInfo.port(), (long)6653L);
    }

    @Test
    public void unixFormat() {
        String target = "unix:file";
        this.thrown.expect(IllegalArgumentException.class);
        ControllerInfo controllerInfo = new ControllerInfo(target);
        Assert.assertTrue((String)"wrong type", (boolean)controllerInfo.type().contains("unix"));
        Assert.assertNull((String)"wrong ip", (Object)controllerInfo.ip());
        Assert.assertEquals((String)"wrong port", (long)controllerInfo.port(), (long)-1L);
    }

    @Test
    public void defaultValues() {
        String target = "tcp:192.168.1.1";
        ControllerInfo controllerInfo = new ControllerInfo(target);
        Assert.assertEquals((String)"wrong type", (Object)controllerInfo.type(), (Object)"tcp");
        Assert.assertEquals((String)"wrong ip", (Object)controllerInfo.ip(), (Object)IpAddress.valueOf((String)"192.168.1.1"));
        Assert.assertEquals((String)"wrong port", (long)controllerInfo.port(), (long)6653L);
        String target1 = "ptcp:5000:";
        ControllerInfo controllerInfo2 = new ControllerInfo(target1);
        Assert.assertEquals((String)"wrong type", (Object)controllerInfo2.type(), (Object)"ptcp");
        Assert.assertEquals((String)"wrong ip", (Object)controllerInfo2.ip(), (Object)IpAddress.valueOf((String)"0.0.0.0"));
        Assert.assertEquals((String)"wrong port", (long)controllerInfo2.port(), (long)5000L);
        String target2 = "ptcp:";
        ControllerInfo controllerInfo3 = new ControllerInfo(target2);
        Assert.assertEquals((String)"wrong type", (Object)controllerInfo3.type(), (Object)"ptcp");
        Assert.assertEquals((String)"wrong ip", (Object)controllerInfo3.ip(), (Object)IpAddress.valueOf((String)"0.0.0.0"));
        Assert.assertEquals((String)"wrong port", (long)controllerInfo3.port(), (long)6653L);
    }

    @Test
    public void testEquals() {
        String target1 = "ptcp:6653:192.168.1.1";
        ControllerInfo controllerInfo1 = new ControllerInfo(target1);
        String target2 = "ptcp:6653:192.168.1.1";
        ControllerInfo controllerInfo2 = new ControllerInfo(target2);
        Assert.assertTrue((String)"wrong equals method", (boolean)controllerInfo1.equals((Object)controllerInfo2));
    }

    @Test
    public void testListEquals() {
        String target1 = "ptcp:6653:192.168.1.1";
        ControllerInfo controllerInfo1 = new ControllerInfo(target1);
        String target2 = "ptcp:6653:192.168.1.1";
        ControllerInfo controllerInfo2 = new ControllerInfo(target2);
        String target3 = "tcp:192.168.1.1:6653";
        ControllerInfo controllerInfo3 = new ControllerInfo(target3);
        String target4 = "tcp:192.168.1.1:6653";
        ControllerInfo controllerInfo4 = new ControllerInfo(target4);
        ArrayList<ControllerInfo> list1 = new ArrayList<ControllerInfo>(Arrays.asList(controllerInfo1, controllerInfo3));
        ArrayList<ControllerInfo> list2 = new ArrayList<ControllerInfo>(Arrays.asList(controllerInfo2, controllerInfo4));
        Assert.assertTrue((String)"wrong equals list method", (boolean)list1.equals(list2));
    }
}

