/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.VlanId;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.DefaultMirroringDescription;
import org.onosproject.net.behaviour.MirroringDescription;
import org.onosproject.net.behaviour.MirroringName;

public class DefaultMirroringDescriptionTest {
    private static final MirroringName NAME_1 = MirroringName.mirroringName((String)"mirror1");
    private static final List<String> MONITOR_SRC_PORTS_1 = ImmutableList.of((Object)"s1", (Object)"s2", (Object)"s3");
    private static final List<String> MONITOR_DST_PORTS_1 = ImmutableList.of((Object)"d1", (Object)"d2");
    private static final List<VlanId> MONITOR_VLANS_1 = ImmutableList.of((Object)VlanId.ANY);
    private static final Optional<String> MIRROR_PORT_1 = Optional.of("port1");
    private static final Optional<VlanId> MIRROR_VLAN_1 = Optional.of(VlanId.ANY);
    private MirroringDescription md1 = new DefaultMirroringDescription(NAME_1, MONITOR_SRC_PORTS_1, MONITOR_DST_PORTS_1, MONITOR_VLANS_1, MIRROR_PORT_1, MIRROR_VLAN_1, new SparseAnnotations[0]);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultMirroringDescription.class);
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.md1.name(), (Matcher)Matchers.is((Object)NAME_1));
        MatcherAssert.assertThat((Object)this.md1.monitorSrcPorts(), (Matcher)Matchers.is(MONITOR_SRC_PORTS_1));
        MatcherAssert.assertThat((Object)this.md1.monitorDstPorts(), (Matcher)Matchers.is(MONITOR_DST_PORTS_1));
        MatcherAssert.assertThat((Object)this.md1.monitorVlans(), (Matcher)Matchers.is(MONITOR_VLANS_1));
        MatcherAssert.assertThat((Object)this.md1.mirrorPort(), (Matcher)Matchers.is(MIRROR_PORT_1));
        MatcherAssert.assertThat((Object)this.md1.mirrorVlan(), (Matcher)Matchers.is(MIRROR_VLAN_1));
    }

    @Test
    public void testToString() {
        String result = this.md1.toString();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)("name=" + NAME_1.toString())));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)("monitorsrcports=" + MONITOR_SRC_PORTS_1.toString())));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)("monitordstports=" + MONITOR_DST_PORTS_1.toString())));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)("monitorvlans=" + MONITOR_VLANS_1.toString())));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)("mirrorport=" + MIRROR_PORT_1.toString())));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)("mirrorvlan=" + MIRROR_VLAN_1.toString())));
    }
}

