/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.AbstractExtension;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;

public class DefaultTrafficSelectorTest {
    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultTrafficSelector.class);
    }

    @Test
    public void testEquals() {
        TrafficSelector selector1 = DefaultTrafficSelector.builder().add(Criteria.matchLambda((Lambda)new OchSignal(GridType.FLEX, ChannelSpacing.CHL_100GHZ, 1, 1))).build();
        TrafficSelector sameAsSelector1 = DefaultTrafficSelector.builder().add(Criteria.matchLambda((Lambda)new OchSignal(GridType.FLEX, ChannelSpacing.CHL_100GHZ, 1, 1))).build();
        TrafficSelector selector2 = DefaultTrafficSelector.builder().add(Criteria.matchLambda((Lambda)new OchSignal(GridType.FLEX, ChannelSpacing.CHL_50GHZ, 1, 1))).build();
        new EqualsTester().addEqualityGroup(new Object[]{selector1, sameAsSelector1}).addEqualityGroup(new Object[]{selector2}).testEquals();
    }

    @Test
    public void testCriteriaOrder() {
        TrafficSelector selector1 = DefaultTrafficSelector.builder().matchInPort(PortNumber.portNumber((long)11L)).matchEthType(Ethernet.TYPE_ARP).build();
        TrafficSelector selector2 = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP).matchInPort(PortNumber.portNumber((long)11L)).build();
        ArrayList criteria1 = Lists.newArrayList((Iterable)selector1.criteria());
        ArrayList criteria2 = Lists.newArrayList((Iterable)selector2.criteria());
        new EqualsTester().addEqualityGroup(new Object[]{criteria1, criteria2}).testEquals();
    }

    @Factory
    public static Matcher<TrafficSelector> hasCriterionWithType(Criterion.Type type) {
        return new CriterionExistsMatcher(type);
    }

    @Test
    public void testCriteriaCreation() {
        long longValue = 305419896L;
        int intValue = 22;
        int shortValue = 33;
        int byteValue = 44;
        int dscpValue = 15;
        int ecnValue = 3;
        MacAddress macValue = MacAddress.valueOf((String)"11:22:33:44:55:66");
        IpPrefix ipPrefixValue = IpPrefix.valueOf((String)"192.168.1.0/24");
        IpPrefix ipv6PrefixValue = IpPrefix.valueOf((String)"fe80::1/64");
        Ip6Address ipv6AddressValue = Ip6Address.valueOf((String)"fe80::1");
        TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(PortNumber.portNumber((long)11L)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IN_PORT));
        selector = DefaultTrafficSelector.builder().matchInPhyPort(PortNumber.portNumber((long)11L)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IN_PHY_PORT));
        selector = DefaultTrafficSelector.builder().matchMetadata(305419896L).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.METADATA));
        selector = DefaultTrafficSelector.builder().matchEthDst(macValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ETH_DST));
        selector = DefaultTrafficSelector.builder().matchEthSrc(macValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ETH_SRC));
        selector = DefaultTrafficSelector.builder().matchEthType((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ETH_TYPE));
        selector = DefaultTrafficSelector.builder().matchVlanId(VlanId.vlanId((short)33)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.VLAN_VID));
        selector = DefaultTrafficSelector.builder().matchVlanPcp((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.VLAN_PCP));
        selector = DefaultTrafficSelector.builder().matchIPDscp((byte)15).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IP_DSCP));
        selector = DefaultTrafficSelector.builder().matchIPEcn((byte)3).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IP_ECN));
        selector = DefaultTrafficSelector.builder().matchIPProtocol((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IP_PROTO));
        selector = DefaultTrafficSelector.builder().matchIPSrc(ipPrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV4_SRC));
        selector = DefaultTrafficSelector.builder().matchIPDst(ipPrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV4_DST));
        selector = DefaultTrafficSelector.builder().matchTcpSrc(TpPort.tpPort((int)22)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.TCP_SRC));
        selector = DefaultTrafficSelector.builder().matchTcpDst(TpPort.tpPort((int)22)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.TCP_DST));
        selector = DefaultTrafficSelector.builder().matchUdpSrc(TpPort.tpPort((int)22)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.UDP_SRC));
        selector = DefaultTrafficSelector.builder().matchUdpDst(TpPort.tpPort((int)22)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.UDP_DST));
        selector = DefaultTrafficSelector.builder().matchSctpSrc(TpPort.tpPort((int)22)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.SCTP_SRC));
        selector = DefaultTrafficSelector.builder().matchSctpDst(TpPort.tpPort((int)22)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.SCTP_DST));
        selector = DefaultTrafficSelector.builder().matchIcmpType((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ICMPV4_TYPE));
        selector = DefaultTrafficSelector.builder().matchIcmpCode((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ICMPV4_CODE));
        selector = DefaultTrafficSelector.builder().matchIPv6Src(ipv6PrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_SRC));
        selector = DefaultTrafficSelector.builder().matchIPv6Dst(ipv6PrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_DST));
        selector = DefaultTrafficSelector.builder().matchIPv6FlowLabel(22).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_FLABEL));
        selector = DefaultTrafficSelector.builder().matchIcmpv6Type((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ICMPV6_TYPE));
        selector = DefaultTrafficSelector.builder().matchIPv6NDTargetAddress(ipv6AddressValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_ND_TARGET));
        selector = DefaultTrafficSelector.builder().matchIPv6NDSourceLinkLayerAddress(macValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_ND_SLL));
        selector = DefaultTrafficSelector.builder().matchIPv6NDTargetLinkLayerAddress(macValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_ND_TLL));
        selector = DefaultTrafficSelector.builder().matchMplsLabel(MplsLabel.mplsLabel((int)3)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.MPLS_LABEL));
        selector = DefaultTrafficSelector.builder().matchIPv6ExthdrFlags(Criterion.IPv6ExthdrFlags.NONEXT.getValue()).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_EXTHDR));
        selector = DefaultTrafficSelector.builder().add(Criteria.matchLambda((Lambda)new OchSignal(GridType.DWDM, ChannelSpacing.CHL_100GHZ, 1, 1))).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.OCH_SIGID));
        selector = DefaultTrafficSelector.builder().matchEthDst(macValue).extension((ExtensionSelector)new MockExtensionSelector(1), DeviceId.NONE).extension((ExtensionSelector)new MockExtensionSelector(2), DeviceId.NONE).build();
        MatcherAssert.assertThat((Object)selector.criteria().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3)));
    }

    private class MockExtensionSelector
    extends AbstractExtension
    implements ExtensionSelector {
        ExtensionSelectorType type;

        MockExtensionSelector(int typeInt) {
            this.type = new ExtensionSelectorType(typeInt);
        }

        public ExtensionSelectorType type() {
            return this.type;
        }

        public byte[] serialize() {
            return new byte[0];
        }

        public void deserialize(byte[] data) {
        }
    }

    public static final class CriterionExistsMatcher
    extends TypeSafeMatcher<TrafficSelector> {
        private final Criterion.Type type;

        public CriterionExistsMatcher(Criterion.Type typeValue) {
            this.type = typeValue;
        }

        public boolean matchesSafely(TrafficSelector selector) {
            Set criteria = selector.criteria();
            return Matchers.notNullValue().matches((Object)criteria) && Matchers.hasSize((int)1).matches((Object)criteria) && Matchers.notNullValue().matches((Object)selector.getCriterion(this.type));
        }

        public void describeTo(Description description) {
            description.appendText("a criterion with type \" ").appendText(this.type.toString()).appendText("\"");
        }
    }
}

