/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.TestDeviceParams;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;

public class DefaultHostDecriptionTest
extends TestDeviceParams {
    private static final Set<HostLocation> LOCATIONS = ImmutableSet.of((Object)LOC1, (Object)LOC2, (Object)LOC3);
    private static final HostDescription SINGLE_HOMED_HOST_DESCR = new DefaultHostDescription(MAC1, VLAN1, LOC1, IP1, new SparseAnnotations[0]);
    private static final HostDescription MULTI_HOMED_HOST_DESCR = new DefaultHostDescription(MAC1, VLAN1, LOCATIONS, IPSET1, false, new SparseAnnotations[0]);

    @Test
    public void basics() {
        Assert.assertEquals((String)"incorrect mac", (Object)MAC1, (Object)SINGLE_HOMED_HOST_DESCR.hwAddress());
        Assert.assertEquals((String)"incorrect vlan", (Object)VLAN1, (Object)SINGLE_HOMED_HOST_DESCR.vlan());
        Assert.assertEquals((String)"incorrect location", (Object)LOC1, (Object)SINGLE_HOMED_HOST_DESCR.location());
        Assert.assertEquals((String)"incorrect IPs", (Object)ImmutableSet.of((Object)IP1), (Object)SINGLE_HOMED_HOST_DESCR.ipAddress());
        Assert.assertTrue((String)"incorrect toString", (boolean)SINGLE_HOMED_HOST_DESCR.toString().contains("vlan=11"));
    }

    @Test
    public void testLocation() {
        Assert.assertEquals((String)"Latest location should be LOC3", (Object)LOC3, (Object)MULTI_HOMED_HOST_DESCR.location());
    }

    @Test
    public void testLocations() {
        Set locations = MULTI_HOMED_HOST_DESCR.locations();
        Assert.assertEquals((String)"There should be 3 locations", (long)locations.size(), (long)3L);
        Assert.assertTrue((String)"Host location contains 1st location", (boolean)locations.contains(LOC1));
        Assert.assertTrue((String)"Host location contains 2nd location", (boolean)locations.contains(LOC2));
        Assert.assertTrue((String)"Host location contains 3rd location", (boolean)locations.contains(LOC3));
    }
}

