/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.event.EventListener;
import org.onosproject.net.intent.AbstractIntentTest;
import org.onosproject.net.intent.FakeIntentManager;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentException;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.TestInstallableIntent;
import org.onosproject.net.intent.TestIntent;
import org.onosproject.net.intent.TestSubclassInstallableIntent;
import org.onosproject.net.intent.TestSubclassIntent;
import org.onosproject.net.intent.TestTools;
import org.onosproject.net.intent.TestableIntentService;

public class IntentServiceTest
extends AbstractIntentTest {
    public static final int IID = 123;
    public static final int INSTALLABLE_IID = 234;
    protected static final int GRACE_MS = 500;
    protected TestableIntentService service;
    protected TestListener listener = new TestListener();

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.service = this.createIntentService();
        this.service.addListener((EventListener)this.listener);
    }

    @Override
    @After
    public void tearDown() {
        this.service.removeListener((EventListener)this.listener);
        super.tearDown();
    }

    protected TestableIntentService createIntentService() {
        return new FakeIntentManager();
    }

    @Test
    public void basics() {
        Assert.assertEquals((String)"incorrect intent count", (long)0L, (long)this.service.getIntentCount());
        this.service.registerCompiler(TestIntent.class, new TestCompiler(new TestInstallableIntent(234)));
        TestIntent intent = new TestIntent(123);
        this.service.submit(intent);
        TestTools.assertAfter(500, () -> Assert.assertEquals((String)"incorrect intent state", (Object)IntentState.INSTALLED, (Object)this.service.getIntentState(intent.key())));
        this.validateEvents(intent, IntentEvent.Type.INSTALL_REQ, IntentEvent.Type.INSTALLED);
        Assert.assertEquals((String)"incorrect intent count", (long)1L, (long)this.service.getIntentCount());
        this.listener.events.clear();
        this.service.withdraw(intent);
        TestTools.assertAfter(500, () -> Assert.assertEquals((String)"incorrect intent state", (Object)IntentState.WITHDRAWN, (Object)this.service.getIntentState(intent.key())));
        this.validateEvents(intent, IntentEvent.Type.WITHDRAWN);
    }

    @Test
    public void failedCompilation() {
        this.service.registerCompiler(TestIntent.class, new TestCompiler(true));
        TestIntent intent = new TestIntent(123);
        this.service.submit(intent);
        TestTools.assertAfter(500, () -> Assert.assertEquals((String)"incorrect intent state", (Object)IntentState.FAILED, (Object)this.service.getIntentState(intent.key())));
        this.validateEvents(intent, IntentEvent.Type.INSTALL_REQ, IntentEvent.Type.FAILED);
    }

    protected void validateEvents(Intent intent, IntentEvent.Type ... types) {
        Iterator<IntentEvent> events = this.listener.events.iterator();
        for (IntentEvent.Type type : types) {
            IntentEvent event;
            IntentEvent intentEvent = event = events.hasNext() ? events.next() : null;
            if (event == null) {
                Assert.fail((String)("expected event not found: " + type));
                continue;
            }
            if (!intent.equals(event.subject())) continue;
            Assert.assertEquals((String)"incorrect state", (Object)type, (Object)event.type());
        }
        while (events.hasNext()) {
            Assert.assertFalse((String)"unexpected event for intent", (boolean)intent.equals(events.next().subject()));
        }
    }

    @Test
    public void compilerBasics() {
        Assert.assertEquals((String)"incorrect compiler count", (long)0L, (long)this.service.getCompilers().size());
        TestCompiler compiler = new TestCompiler(false);
        this.service.registerCompiler(TestIntent.class, compiler);
        Assert.assertEquals((String)"incorrect compiler", (Object)compiler, this.service.getCompilers().get(TestIntent.class));
        this.service.unregisterCompiler(TestIntent.class);
        Assert.assertNull((String)"compiler should not be registered", this.service.getCompilers().get(TestIntent.class));
    }

    @Test
    public void implicitRegistration() {
        TestCompiler compiler = new TestCompiler(new TestSubclassInstallableIntent(234));
        this.service.registerCompiler(TestIntent.class, compiler);
        Assert.assertEquals((String)"incorrect compiler", (Object)compiler, this.service.getCompilers().get(TestIntent.class));
        TestSubclassIntent intent = new TestSubclassIntent(123);
        this.service.submit(intent);
        TestTools.assertAfter(500, () -> Assert.assertEquals((String)"incorrect intent state", (Object)IntentState.INSTALLED, (Object)this.service.getIntentState(intent.key())));
        Assert.assertEquals((String)"incorrect compiler", (Object)compiler, this.service.getCompilers().get(TestSubclassIntent.class));
    }

    private class TestCompiler
    implements IntentCompiler<TestIntent> {
        private final boolean fail;
        private final List<Intent> result;

        TestCompiler(boolean fail) {
            this.fail = fail;
            this.result = Collections.emptyList();
        }

        TestCompiler(Intent ... result) {
            this.fail = false;
            this.result = Arrays.asList(result);
        }

        public List<Intent> compile(TestIntent intent, List<Intent> installable) {
            if (this.fail) {
                throw new IntentException("compile failed by design");
            }
            ArrayList<Intent> compiled = new ArrayList<Intent>(this.result);
            return compiled;
        }
    }

    protected class TestListener
    implements IntentListener {
        final List<IntentEvent> events = new ArrayList<IntentEvent>();

        protected TestListener() {
        }

        public void event(IntentEvent event) {
            this.events.add(event);
        }
    }
}

