/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.intent.Key;

public class KeyTest {
    private static final String KEY_1 = "key1";
    private static final String KEY_2 = "key2";
    private static final String KEY_3 = "key3";
    private static final long LONG_KEY_1 = 4369L;
    private static final long LONG_KEY_2 = 8738L;
    private static final long LONG_KEY_3 = 13107L;

    @Test
    public void keysAreImmutable() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(Key.class);
        Key longKey = Key.of((long)11259375L, (ApplicationId)NetTestTools.APP_ID);
        ImmutableClassChecker.assertThatClassIsImmutable(longKey.getClass());
        Key stringKey = Key.of((String)"some key", (ApplicationId)NetTestTools.APP_ID);
        ImmutableClassChecker.assertThatClassIsImmutable(stringKey.getClass());
    }

    @Test
    public void stringKeyConstruction() {
        Key stringKey1 = Key.of((String)KEY_3, (ApplicationId)NetTestTools.APP_ID);
        MatcherAssert.assertThat((Object)stringKey1, (Matcher)Matchers.notNullValue());
        Key stringKey2 = Key.of((String)KEY_3, (ApplicationId)NetTestTools.APP_ID);
        MatcherAssert.assertThat((Object)stringKey2, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)stringKey1.hash(), (Matcher)Matchers.is((Object)stringKey2.hash()));
    }

    @Test
    public void longKeyConstruction() {
        Key longKey1 = Key.of((long)13107L, (ApplicationId)NetTestTools.APP_ID);
        MatcherAssert.assertThat((Object)longKey1, (Matcher)Matchers.notNullValue());
        Key longKey2 = Key.of((long)13107L, (ApplicationId)NetTestTools.APP_ID);
        MatcherAssert.assertThat((Object)longKey2, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)longKey1.hash(), (Matcher)Matchers.is((Object)longKey2.hash()));
    }

    @Test
    public void stringKey() {
        Key stringKey1 = Key.of((String)KEY_1, (ApplicationId)NetTestTools.APP_ID);
        Key copyOfStringKey1 = Key.of((String)KEY_1, (ApplicationId)NetTestTools.APP_ID);
        Key stringKey2 = Key.of((String)KEY_2, (ApplicationId)NetTestTools.APP_ID);
        Key copyOfStringKey2 = Key.of((String)KEY_2, (ApplicationId)NetTestTools.APP_ID);
        Key stringKey3 = Key.of((String)KEY_3, (ApplicationId)NetTestTools.APP_ID);
        new EqualsTester().addEqualityGroup(new Object[]{stringKey1, copyOfStringKey1}).addEqualityGroup(new Object[]{stringKey2, copyOfStringKey2}).addEqualityGroup(new Object[]{stringKey3}).testEquals();
    }

    @Test
    public void longKey() {
        Key longKey1 = Key.of((long)4369L, (ApplicationId)NetTestTools.APP_ID);
        Key copyOfLongKey1 = Key.of((long)4369L, (ApplicationId)NetTestTools.APP_ID);
        Key longKey2 = Key.of((long)8738L, (ApplicationId)NetTestTools.APP_ID);
        Key copyOfLongKey2 = Key.of((long)8738L, (ApplicationId)NetTestTools.APP_ID);
        Key longKey3 = Key.of((long)13107L, (ApplicationId)NetTestTools.APP_ID);
        new EqualsTester().addEqualityGroup(new Object[]{longKey1, copyOfLongKey1}).addEqualityGroup(new Object[]{longKey2, copyOfLongKey2}).addEqualityGroup(new Object[]{longKey3}).testEquals();
    }
}

