/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import org.junit.Assert;

public final class TestTools {
    private TestTools() {
    }

    public static void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"unexpected interrupt");
        }
    }

    public static void assertAfter(long start, int delay, int step, int duration, Runnable assertions) {
        TestTools.delay(delay);
        while (true) {
            try {
                assertions.run();
            }
            catch (AssertionError e) {
                if (System.currentTimeMillis() - start > (long)duration) {
                    throw e;
                }
                TestTools.delay(step);
                continue;
            }
            break;
        }
    }

    public static void assertAfter(int delay, int step, int duration, Runnable assertions) {
        TestTools.assertAfter(System.currentTimeMillis(), delay, step, duration, assertions);
    }

    public static void assertAfter(int step, int duration, Runnable assertions) {
        TestTools.assertAfter(step, step, duration, assertions);
    }

    public static void assertAfter(int duration, Runnable assertions) {
        int step = Math.min(duration, Math.max(10, duration / 10));
        TestTools.assertAfter(step, duration, assertions);
    }
}

