/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.packet.DefaultInboundPacket;

public class DefaultInboundPacketTest {
    final Ethernet eth = new Ethernet().setDestinationMACAddress(MacAddress.BROADCAST).setSourceMACAddress(MacAddress.BROADCAST);
    final ByteBuffer byteBuffer = ByteBuffer.wrap(this.eth.serialize());
    final DefaultInboundPacket packet1 = new DefaultInboundPacket(NetTestTools.connectPoint("d1", 1), this.eth, this.byteBuffer, Optional.of(1L));
    final DefaultInboundPacket sameAsPacket1 = new DefaultInboundPacket(NetTestTools.connectPoint("d1", 1), this.eth, this.byteBuffer, Optional.of(1L));
    final DefaultInboundPacket packet2 = new DefaultInboundPacket(NetTestTools.connectPoint("d2", 1), this.eth, this.byteBuffer);
    final DefaultInboundPacket sameAsPacket2 = new DefaultInboundPacket(NetTestTools.connectPoint("d2", 1), this.eth, this.byteBuffer, Optional.empty());

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultInboundPacket.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.packet1, this.sameAsPacket1}).addEqualityGroup(new Object[]{this.packet2, this.sameAsPacket2}).testEquals();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.packet1.receivedFrom(), (Matcher)Matchers.equalTo((Object)NetTestTools.connectPoint("d1", 1)));
        MatcherAssert.assertThat((Object)this.packet1.parsed(), (Matcher)Matchers.equalTo((Object)this.eth));
        MatcherAssert.assertThat((Object)this.packet1.unparsed(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.packet1.cookie(), (Matcher)Matchers.equalTo(Optional.of(1L)));
    }
}

