/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.pi.model.PiActionId;
import org.onosproject.net.pi.model.PiTableId;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiCounterCellData;
import org.onosproject.net.pi.runtime.PiCounterCellId;
import org.onosproject.net.pi.runtime.PiTableAction;
import org.onosproject.net.pi.runtime.PiTableEntry;

public class PiCounterCellDataTest {
    private static final PiTableEntry PI_TABLE_ENTRY_1 = PiTableEntry.builder().forTable(PiTableId.of((String)"T10")).withCookie(172L).withPriority(10).withAction((PiTableAction)PiAction.builder().withId(PiActionId.of((String)"drop")).build()).withTimeout(100.0).build();
    private static final PiTableEntry PI_TABLE_ENTRY_2 = PiTableEntry.builder().forTable(PiTableId.of((String)"T20")).withCookie(172L).withPriority(10).withAction((PiTableAction)PiAction.builder().withId(PiActionId.of((String)"drop")).build()).withTimeout(1000.0).build();
    private static final PiCounterCellId PI_COUNTER_CELL_ID_1 = PiCounterCellId.ofDirect((PiTableEntry)PI_TABLE_ENTRY_1);
    private static final PiCounterCellId PI_COUNTER_CELL_ID_2 = PiCounterCellId.ofDirect((PiTableEntry)PI_TABLE_ENTRY_2);
    private static final long PACKETS_1 = 10L;
    private static final long PACKETS_2 = 20L;
    private static final long BYTES_1 = 100L;
    private static final long BYTES_2 = 200L;
    private static final PiCounterCellData PI_COUNTER_CELL_DATA_1 = new PiCounterCellData(PI_COUNTER_CELL_ID_1, 10L, 100L);
    private static final PiCounterCellData SAME_AS_PI_COUNTER_CELL_DATA_1 = new PiCounterCellData(PI_COUNTER_CELL_ID_1, 10L, 100L);
    private static final PiCounterCellData PI_COUNTER_CELL_DATA_2 = new PiCounterCellData(PI_COUNTER_CELL_ID_2, 20L, 200L);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiCounterCellData.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{PI_COUNTER_CELL_DATA_1, SAME_AS_PI_COUNTER_CELL_DATA_1}).addEqualityGroup(new Object[]{PI_COUNTER_CELL_DATA_2}).testEquals();
    }
}

